/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout.skin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.libs.org.json.simple.parser.JSONParser;
import me.neznamy.tab.libs.org.json.simple.parser.ParseException;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import org.jetbrains.annotations.NotNull;

public abstract class SkinSource {
    @NotNull
    private final ConfigurationFile file;
    @NotNull
    private final String path;
    @NotNull
    private final Map<String, List<String>> cache;

    protected SkinSource(@NotNull ConfigurationFile file, @NotNull String path) {
        this.file = file;
        this.path = path;
        this.cache = file.getConfigurationSection(path);
    }

    @NotNull
    public List<String> getSkin(@NotNull String skin) {
        if (this.cache.containsKey(skin)) {
            return this.cache.get(skin);
        }
        List<String> properties = this.download(skin);
        if (!properties.isEmpty()) {
            this.cache.put(skin, properties);
            this.file.set(this.path, this.cache);
            return properties;
        }
        return properties;
    }

    @NotNull
    public abstract List<String> download(@NotNull String var1);

    @NotNull
    protected JSONObject getResponse(@NotNull String url) throws IOException, ParseException {
        try (InputStreamReader reader = new InputStreamReader(new URL(url).openStream());){
            JSONObject jSONObject = (JSONObject)new JSONParser().parse(reader);
            return jSONObject;
        }
    }
}

