/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import lombok.NonNull;
import me.neznamy.tab.api.nametag.NameTagManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.features.nametags.CollisionManager;
import me.neznamy.tab.shared.features.nametags.VisibilityRefresher;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.LoginPacketListener;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameTag
extends TabFeature
implements NameTagManager,
JoinListener,
QuitListener,
Loadable,
UnLoadable,
WorldSwitchListener,
ServerSwitchListener,
Refreshable,
LoginPacketListener,
VanishListener {
    protected final boolean invisibleNameTags = this.config().getBoolean("scoreboard-teams.invisible-nametags", false);
    private final boolean canSeeFriendlyInvisibles = this.config().getBoolean("scoreboard-teams.can-see-friendly-invisibles", false);
    private final boolean antiOverride = this.config().getBoolean("scoreboard-teams.anti-override", true);
    private final CollisionManager collisionManager = new CollisionManager(this);
    private final int teamOptions = this.canSeeFriendlyInvisibles ? 2 : 0;
    private final DisableChecker disableChecker;
    private RedisSupport redis;

    public NameTag() {
        Condition disableCondition = Condition.getCondition(this.config().getString("scoreboard-teams.disable-condition"));
        this.disableChecker = new DisableChecker(this.getFeatureName(), disableCondition, this::onDisableConditionChange, p -> p.disabledNametags);
        TAB.getInstance().getFeatureManager().registerFeature("NameTag16-Condition", this.disableChecker);
        if (!this.antiOverride) {
            TAB.getInstance().getConfigHelper().startup().teamAntiOverrideDisabled();
        }
    }

    @Override
    public void load() {
        TAB.getInstance().getFeatureManager().registerFeature("NameTagCollision", this.collisionManager);
        this.collisionManager.load();
        this.redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        TAB.getInstance().getFeatureManager().registerFeature("NameTagVisibility", new VisibilityRefresher(this));
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            all.getScoreboard().setAntiOverrideTeams(this.antiOverride);
            this.updateProperties(all);
            if (this.disableChecker.isDisableConditionMet(all)) {
                all.disabledNametags.set(true);
                continue;
            }
            TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(all, true);
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (target.isVanished() && !TAB.getInstance().getPlatform().canSee(viewer, target)) {
                    target.teamData.vanishedFor.add(viewer.getUniqueId());
                }
                if (target.disabledNametags.get()) continue;
                this.registerTeam(target, viewer);
            }
        }
    }

    @Override
    public void unload() {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (this.hasTeamHandlingPaused(target) || target.disabledNametags.get()) continue;
                viewer.getScoreboard().unregisterTeam(target.sortingData.getShortTeamName());
            }
        }
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (refreshed.disabledNametags.get()) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.getProperty("tagprefix").update();
            boolean suffix = refreshed.getProperty("tagsuffix").update();
            boolean bl = refresh = prefix || suffix;
        }
        if (refresh) {
            this.updateTeamData(refreshed);
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating prefix/suffix";
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        connectedPlayer.getScoreboard().setAntiOverrideTeams(this.antiOverride);
        this.updateProperties(connectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == connectedPlayer) continue;
            if (connectedPlayer.isVanished() && !TAB.getInstance().getPlatform().canSee(all, connectedPlayer)) {
                connectedPlayer.teamData.vanishedFor.add(all.getUniqueId());
            }
            if (all.isVanished() && !TAB.getInstance().getPlatform().canSee(connectedPlayer, all)) {
                all.teamData.vanishedFor.add(connectedPlayer.getUniqueId());
            }
            if (all.disabledNametags.get()) continue;
            this.registerTeam(all, connectedPlayer);
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(connectedPlayer, true);
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.disabledNametags.set(true);
            return;
        }
        this.registerTeam(connectedPlayer);
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        if (!disconnectedPlayer.disabledNametags.get() && !this.hasTeamHandlingPaused(disconnectedPlayer)) {
            String teamName = disconnectedPlayer.sortingData.getShortTeamName();
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer == disconnectedPlayer || !viewer.getScoreboard().containsTeam(teamName)) continue;
                viewer.getScoreboard().unregisterTeam(teamName);
            }
        }
    }

    @Override
    public void onServerChange(@NonNull TabPlayer p, @NonNull String from, @NonNull String to) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (this.updateProperties(p) && !p.disabledNametags.get()) {
            this.updateTeamData(p);
        }
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        if (this.updateProperties(changed) && !changed.disabledNametags.get()) {
            this.updateTeamData(changed);
        }
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            this.unregisterTeam(p, p.sortingData.getShortTeamName());
        } else {
            this.registerTeam(p);
        }
    }

    public void updateTeamData(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.updateTeamData(p, viewer);
        }
        if (this.redis != null) {
            this.redis.updateTeam(p, p.sortingData.getShortTeamName(), p.getProperty("tagprefix").get(), p.getProperty("tagsuffix").get(), this.getTeamVisibility(p, p) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER);
        }
    }

    public void updateTeamData(@NonNull TabPlayer p, @NonNull TabPlayer viewer) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (!viewer.getScoreboard().containsTeam(p.sortingData.getShortTeamName())) {
            return;
        }
        boolean visible = this.getTeamVisibility(p, viewer);
        String prefix = p.getProperty("tagprefix").getFormat(viewer);
        viewer.getScoreboard().updateTeam(p.sortingData.getShortTeamName(), prefix, p.getProperty("tagsuffix").getFormat(viewer), visible ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER, p.teamData.getCollisionRule() ? Scoreboard.CollisionRule.ALWAYS : Scoreboard.CollisionRule.NEVER, this.teamOptions, EnumChatFormat.lastColorsOf(prefix));
    }

    public void unregisterTeam(@NonNull TabPlayer p, @NonNull String teamName) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (this.hasTeamHandlingPaused(p)) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (!viewer.getScoreboard().containsTeam(teamName)) continue;
            viewer.getScoreboard().unregisterTeam(teamName);
        }
    }

    public void registerTeam(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.registerTeam(p, viewer);
        }
    }

    private void registerTeam(@NonNull TabPlayer p, @NonNull TabPlayer viewer) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (this.hasTeamHandlingPaused(p)) {
            return;
        }
        if (!TAB.getInstance().getPlatform().canSee(viewer, p) && p != viewer) {
            return;
        }
        String prefix = p.getProperty("tagprefix").getFormat(viewer);
        viewer.getScoreboard().registerTeam(p.sortingData.getShortTeamName(), prefix, p.getProperty("tagsuffix").getFormat(viewer), this.getTeamVisibility(p, viewer) ? Scoreboard.NameVisibility.ALWAYS : Scoreboard.NameVisibility.NEVER, p.teamData.getCollisionRule() ? Scoreboard.CollisionRule.ALWAYS : Scoreboard.CollisionRule.NEVER, Collections.singletonList(p.getNickname()), this.teamOptions, EnumChatFormat.lastColorsOf(prefix));
    }

    protected boolean updateProperties(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        boolean changed = p.loadPropertyFromConfig(this, "tagprefix");
        if (p.loadPropertyFromConfig(this, "tagsuffix")) {
            changed = true;
        }
        return changed;
    }

    public boolean getTeamVisibility(@NonNull TabPlayer p, @NonNull TabPlayer viewer) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (viewer.getVersion().getMinorVersion() == 8 && p.hasInvisibilityPotion()) {
            return false;
        }
        return !this.hasHiddenNameTag(p) && !this.hasHiddenNameTag(p, viewer) && !this.invisibleNameTags && !viewer.teamData.invisibleNameTagView;
    }

    @Override
    public void onLoginPacket(TabPlayer player) {
        if (!player.isLoaded()) {
            return;
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all.disabledNametags.get() || !all.isLoaded()) continue;
            this.registerTeam(all, player);
        }
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        if (player.isVanished()) {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer == player || TAB.getInstance().getPlatform().canSee(viewer, player)) continue;
                player.teamData.vanishedFor.add(viewer.getUniqueId());
                viewer.getScoreboard().unregisterTeam(player.sortingData.getShortTeamName());
            }
        } else {
            for (UUID id : player.teamData.vanishedFor) {
                TabPlayer viewer = TAB.getInstance().getPlayer(id);
                if (viewer == null) continue;
                this.registerTeam(player, viewer);
            }
            player.teamData.vanishedFor.clear();
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "NameTags";
    }

    @Override
    public void hideNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (!p.teamData.hiddenNameTag) {
            p.teamData.hiddenNameTag = true;
            this.updateTeamData(p);
        }
    }

    @Override
    public void hideNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (!p.teamData.hiddenNameTagFor.add((TabPlayer)viewer)) {
            return;
        }
        this.updateTeamData(p, (TabPlayer)viewer);
    }

    @Override
    public void showNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (p.teamData.hiddenNameTag) {
            p.teamData.hiddenNameTag = false;
            this.updateTeamData(p);
        }
    }

    @Override
    public void showNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (!p.teamData.hiddenNameTagFor.remove((TabPlayer)viewer)) {
            return;
        }
        this.updateTeamData(p, (TabPlayer)viewer);
    }

    @Override
    public boolean hasHiddenNameTag(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.hiddenNameTag;
    }

    @Override
    public boolean hasHiddenNameTag(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull me.neznamy.tab.api.TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.hiddenNameTagFor.contains((TabPlayer)viewer);
    }

    @Override
    public void pauseTeamHandling(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (p.teamData.teamHandlingPaused) {
            return;
        }
        if (!p.disabledNametags.get()) {
            this.unregisterTeam(p, p.sortingData.getShortTeamName());
        }
        p.teamData.teamHandlingPaused = true;
    }

    @Override
    public void resumeTeamHandling(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (!p.teamData.teamHandlingPaused) {
            return;
        }
        p.teamData.teamHandlingPaused = false;
        if (!p.disabledNametags.get()) {
            this.registerTeam(p);
        }
    }

    @Override
    public boolean hasTeamHandlingPaused(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.teamHandlingPaused;
    }

    @Override
    public void setCollisionRule(@NonNull me.neznamy.tab.api.TabPlayer player, Boolean collision) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        if (Objects.equals(p.teamData.forcedCollision, collision)) {
            return;
        }
        p.teamData.forcedCollision = collision;
        this.updateTeamData(p);
    }

    @Override
    public Boolean getCollisionRule(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.teamData.forcedCollision;
    }

    @Override
    public void setPrefix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String prefix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        p.getProperty("tagprefix").setTemporaryValue(prefix);
        this.updateTeamData(p);
    }

    @Override
    public void setSuffix(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable String suffix) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        p.getProperty("tagsuffix").setTemporaryValue(suffix);
        this.updateTeamData(p);
    }

    @Override
    public String getCustomPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.getProperty("tagprefix").getTemporaryValue();
    }

    @Override
    public String getCustomSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.getProperty("tagsuffix").getTemporaryValue();
    }

    @Override
    @NonNull
    public String getOriginalPrefix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.getProperty("tagprefix").getOriginalRawValue();
    }

    @Override
    @NonNull
    public String getOriginalSuffix(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer p = (TabPlayer)player;
        p.ensureLoaded();
        return p.getProperty("tagsuffix").getOriginalRawValue();
    }

    @Override
    public void toggleNameTagVisibilityView(@NonNull me.neznamy.tab.api.TabPlayer p, boolean sendToggleMessage) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        if (player.teamData.invisibleNameTagView) {
            player.teamData.invisibleNameTagView = false;
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsShown(), true);
            }
        } else {
            player.teamData.invisibleNameTagView = true;
            if (sendToggleMessage) {
                player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNameTagsHidden(), true);
            }
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setNameTagVisibility(player, !player.teamData.invisibleNameTagView);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.updateTeamData(all, player);
        }
    }

    @Override
    public boolean hasHiddenNameTagVisibilityView(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).teamData.invisibleNameTagView;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public int getTeamOptions() {
        return this.teamOptions;
    }

    public DisableChecker getDisableChecker() {
        return this.disableChecker;
    }

    public static class PlayerData {
        public boolean hiddenNameTag;
        public final Set<TabPlayer> hiddenNameTagFor = Collections.newSetFromMap(new WeakHashMap());
        public boolean teamHandlingPaused;
        public boolean invisibleNameTagView;
        public final Set<UUID> vanishedFor = new HashSet<UUID>();
        public boolean collisionRule;
        @Nullable
        public Boolean forcedCollision;

        public boolean getCollisionRule() {
            return this.forcedCollision != null ? this.forcedCollision : this.collisionRule;
        }
    }
}

