/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.neznamy.tab.api.event.EventHandler;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.event.impl.TabPlaceholderRegisterEvent;
import me.neznamy.tab.shared.features.BelowName;
import me.neznamy.tab.shared.features.GlobalPlayerList;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.YellowNumber;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.feature.RedisBelowName;
import me.neznamy.tab.shared.features.redis.feature.RedisFeature;
import me.neznamy.tab.shared.features.redis.feature.RedisGlobalPlayerList;
import me.neznamy.tab.shared.features.redis.feature.RedisPlayerList;
import me.neznamy.tab.shared.features.redis.feature.RedisTeams;
import me.neznamy.tab.shared.features.redis.feature.RedisYellowNumber;
import me.neznamy.tab.shared.features.redis.message.Load;
import me.neznamy.tab.shared.features.redis.message.LoadRequest;
import me.neznamy.tab.shared.features.redis.message.PlayerJoin;
import me.neznamy.tab.shared.features.redis.message.PlayerQuit;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.features.redis.message.ServerSwitch;
import me.neznamy.tab.shared.features.redis.message.UpdateVanishStatus;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.LoginPacketListener;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.TabListClearListener;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.VanishListener;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RedisSupport
extends TabFeature
implements JoinListener,
QuitListener,
Loadable,
UnLoadable,
ServerSwitchListener,
LoginPacketListener,
VanishListener,
TabListClearListener {
    @NotNull
    protected final Map<UUID, RedisPlayer> redisPlayers = new ConcurrentHashMap<UUID, RedisPlayer>();
    @NotNull
    private final UUID proxy = UUID.randomUUID();
    @NotNull
    private final List<RedisFeature> features = new ArrayList<RedisFeature>();
    @Nullable
    private RedisBelowName redisBelowName;
    @Nullable
    private RedisYellowNumber redisYellowNumber;
    @Nullable
    private RedisPlayerList redisPlayerList;
    @Nullable
    private RedisTeams redisTeams;
    private EventHandler<TabPlaceholderRegisterEvent> eventHandler;
    @NotNull
    private final Map<String, Supplier<RedisMessage>> messages = new HashMap<String, Supplier<RedisMessage>>();
    @NotNull
    private final Map<Class<? extends RedisMessage>, String> classStringMap = new HashMap<Class<? extends RedisMessage>, String>();

    protected RedisSupport() {
        this.registerMessage("load", Load.class, Load::new);
        this.registerMessage("loadrequest", LoadRequest.class, LoadRequest::new);
        this.registerMessage("join", PlayerJoin.class, PlayerJoin::new);
        this.registerMessage("quit", PlayerQuit.class, PlayerQuit::new);
        this.registerMessage("server", ServerSwitch.class, ServerSwitch::new);
        this.registerMessage("vanish", UpdateVanishStatus.class, UpdateVanishStatus::new);
    }

    public void updateTabFormat(@NotNull TabPlayer p, @NotNull String format) {
        if (this.redisPlayerList == null) {
            return;
        }
        RedisPlayerList redisPlayerList = this.redisPlayerList;
        Objects.requireNonNull(redisPlayerList);
        this.sendMessage(new RedisPlayerList.Update(redisPlayerList, p.getTablistId(), format));
    }

    public void updateTeam(@NotNull TabPlayer p, @NotNull String teamName, @NotNull String tagPrefix, @NotNull String tagSuffix, @NotNull Scoreboard.NameVisibility nameVisibility) {
        if (this.redisTeams == null) {
            return;
        }
        RedisTeams redisTeams = this.redisTeams;
        Objects.requireNonNull(redisTeams);
        this.sendMessage(new RedisTeams.Update(redisTeams, p.getTablistId(), teamName, tagPrefix, tagSuffix, nameVisibility));
    }

    public void updateBelowName(@NotNull TabPlayer p, int value, @NotNull String fancyValue) {
        if (this.redisBelowName == null) {
            return;
        }
        RedisBelowName redisBelowName = this.redisBelowName;
        Objects.requireNonNull(redisBelowName);
        this.sendMessage(new RedisBelowName.Update(redisBelowName, p.getTablistId(), value, fancyValue));
    }

    public void updateYellowNumber(@NotNull TabPlayer p, int value, String fancyValue) {
        if (this.redisYellowNumber == null) {
            return;
        }
        RedisYellowNumber redisYellowNumber = this.redisYellowNumber;
        Objects.requireNonNull(redisYellowNumber);
        this.sendMessage(new RedisYellowNumber.Update(redisYellowNumber, p.getTablistId(), value, fancyValue));
    }

    public void processMessage(@NotNull String msg) {
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Redis Message processing", () -> {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])Base64.getDecoder().decode(msg));
            String proxy = in.readUTF();
            if (proxy.equals(this.proxy.toString())) {
                return;
            }
            String action = in.readUTF();
            Supplier<RedisMessage> supplier = this.messages.get(action);
            if (supplier == null) {
                TAB.getInstance().getErrorManager().unknownRedisMessage(action);
                return;
            }
            RedisMessage redisMessage = supplier.get();
            redisMessage.read(in);
            redisMessage.process(this);
        });
    }

    public abstract void sendMessage(@NotNull String var1);

    public abstract void register();

    public abstract void unregister();

    @Override
    public void load() {
        this.register();
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("BelowName")) {
            this.redisBelowName = new RedisBelowName(this, (BelowName)TAB.getInstance().getFeatureManager().getFeature("BelowName"));
            this.features.add(this.redisBelowName);
        }
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("YellowNumber")) {
            this.redisYellowNumber = new RedisYellowNumber(this, (YellowNumber)TAB.getInstance().getFeatureManager().getFeature("YellowNumber"));
            this.features.add(this.redisYellowNumber);
        }
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("PlayerList")) {
            this.redisPlayerList = new RedisPlayerList(this, (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList"));
            this.features.add(this.redisPlayerList);
        }
        if (TAB.getInstance().getNameTagManager() != null) {
            this.redisTeams = new RedisTeams(this, TAB.getInstance().getNameTagManager());
            this.features.add(this.redisTeams);
        }
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList")) {
            this.features.add(new RedisGlobalPlayerList(this, (GlobalPlayerList)TAB.getInstance().getFeatureManager().getFeature("GlobalPlayerList")));
        }
        this.overridePlaceholders();
        TAB.getInstance().getEventBus().register(TabPlaceholderRegisterEvent.class, this.eventHandler);
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
        this.sendMessage(new LoadRequest());
    }

    private void overridePlaceholders() {
        this.eventHandler = event -> {
            String identifier = event.getIdentifier();
            if (identifier.startsWith("%online_")) {
                String server = identifier.substring(8, identifier.length() - 1);
                event.setServerPlaceholder(() -> {
                    int count = 0;
                    for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                        if (!player.getServer().equals(server) || player.isVanished()) continue;
                        ++count;
                    }
                    for (RedisPlayer player : this.redisPlayers.values()) {
                        if (!player.getServer().equals(server) || player.isVanished()) continue;
                        ++count;
                    }
                    return count;
                });
            }
        };
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%online%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished()) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (player.isVanished()) continue;
                ++count;
            }
            return count;
        });
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%staffonline%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished() || !player.hasPermission("tab.staff")) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (player.isVanished() || !player.isStaff()) continue;
                ++count;
            }
            return count;
        });
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%serveronline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).getServer().equals(player.getServer()) || player.isVanished()) continue;
                ++count;
            }
            for (RedisPlayer player : this.redisPlayers.values()) {
                if (!((TabPlayer)p).getServer().equals(player.getServer()) || player.isVanished()) continue;
                ++count;
            }
            return count;
        });
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onQuit(p);
        }
        TAB.getInstance().getEventBus().unregister(this.eventHandler);
        this.unregister();
    }

    @Override
    public void onJoin(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerJoin(this, p));
        this.features.forEach(f -> f.onJoin(p));
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        this.sendMessage(new ServerSwitch(p.getTablistId(), to));
        this.features.forEach(f -> f.onServerSwitch(p));
    }

    @Override
    public void onQuit(@NotNull TabPlayer p) {
        this.sendMessage(new PlayerQuit(p.getTablistId()));
    }

    public void sendMessage(@NotNull RedisMessage message) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.proxy.toString());
        out.writeUTF(this.classStringMap.get(message.getClass()));
        message.write(out);
        this.sendMessage(Base64.getEncoder().encodeToString(out.toByteArray()));
    }

    public void registerMessage(@NotNull String name, @NotNull Class<? extends RedisMessage> clazz, @NotNull Supplier<RedisMessage> supplier) {
        this.messages.put(name, supplier);
        this.classStringMap.put(clazz, name);
    }

    @Override
    public void onLoginPacket(TabPlayer player) {
        this.features.forEach(f -> f.onLoginPacket(player));
    }

    @Override
    public void onTabListClear(@NotNull TabPlayer player) {
        this.features.forEach(f -> f.onTabListClear(player));
    }

    @Override
    public void onVanishStatusChange(@NotNull TabPlayer player) {
        this.sendMessage(new UpdateVanishStatus(player.getTablistId(), player.isVanished()));
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "RedisSupport";
    }

    @NotNull
    public Map<UUID, RedisPlayer> getRedisPlayers() {
        return this.redisPlayers;
    }

    @NotNull
    public UUID getProxy() {
        return this.proxy;
    }

    @NotNull
    public List<RedisFeature> getFeatures() {
        return this.features;
    }

    @Nullable
    public RedisBelowName getRedisBelowName() {
        return this.redisBelowName;
    }

    @Nullable
    public RedisYellowNumber getRedisYellowNumber() {
        return this.redisYellowNumber;
    }

    @Nullable
    public RedisPlayerList getRedisPlayerList() {
        return this.redisPlayerList;
    }

    @Nullable
    public RedisTeams getRedisTeams() {
        return this.redisTeams;
    }

    public EventHandler<TabPlaceholderRegisterEvent> getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    public Map<String, Supplier<RedisMessage>> getMessages() {
        return this.messages;
    }

    @NotNull
    public Map<Class<? extends RedisMessage>, String> getClassStringMap() {
        return this.classStringMap;
    }
}

