/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.feature;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.GlobalPlayerList;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.feature.RedisFeature;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class RedisGlobalPlayerList
extends RedisFeature {
    private final RedisSupport redisSupport;
    private final GlobalPlayerList globalPlayerList;

    @Override
    public void onJoin(@NotNull TabPlayer player) {
        for (RedisPlayer redis : this.redisSupport.getRedisPlayers().values()) {
            if (redis.getServer().equals(player.getServer()) || !this.shouldSee(player, redis)) continue;
            player.getTabList().addEntry(this.getEntry(redis));
        }
    }

    @Override
    public void onJoin(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (!this.shouldSee(viewer, player) || viewer.getServer().equals(player.getServer())) continue;
            viewer.getTabList().addEntry(this.getEntry(player));
        }
    }

    @Override
    public void onServerSwitch(@NotNull RedisPlayer player) {
        TAB.getInstance().getCPUManager().runTaskLater(200, this.redisSupport.getFeatureName(), "Server Switch", () -> {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer.getServer().equals(player.getServer())) continue;
                if (this.shouldSee(viewer, player)) {
                    viewer.getTabList().addEntry(this.getEntry(player));
                    continue;
                }
                viewer.getTabList().removeEntry(player.getUniqueId());
            }
        });
    }

    @Override
    public void onQuit(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (player.getServer().equals(viewer.getServer())) continue;
            viewer.getTabList().removeEntry(player.getUniqueId());
        }
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out, @NotNull TabPlayer player) {
        out.writeBoolean(player.getSkin() != null);
        if (player.getSkin() != null) {
            out.writeUTF(player.getSkin().getValue());
            out.writeBoolean(player.getSkin().getSignature() != null);
            if (player.getSkin().getSignature() != null) {
                out.writeUTF(player.getSkin().getSignature());
            }
        }
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in, @NotNull RedisPlayer player) {
        if (in.readBoolean()) {
            String value = in.readUTF();
            String signature = null;
            if (in.readBoolean()) {
                signature = in.readUTF();
            }
            player.setSkin(new TabList.Skin(value, signature));
        }
    }

    @Override
    public void onTabListClear(@NotNull TabPlayer player) {
        this.onJoin(player);
    }

    private boolean shouldSee(@NotNull TabPlayer viewer, @NotNull RedisPlayer target) {
        if (target.isVanished() && !viewer.hasPermission("tab.seevanished")) {
            return false;
        }
        if (this.globalPlayerList.isSpyServer(viewer.getServer())) {
            return true;
        }
        return this.globalPlayerList.getServerGroup(viewer.getServer()).equals(this.globalPlayerList.getServerGroup(target.getServer()));
    }

    @NotNull
    private TabList.Entry getEntry(@NotNull RedisPlayer player) {
        return new TabList.Entry(player.getUniqueId(), player.getNickname(), player.getSkin(), true, 0, 0, player.getTabFormat());
    }

    @Override
    public void onVanishStatusChange(@NotNull RedisPlayer player) {
        if (player.isVanished()) {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (this.shouldSee(all, player)) continue;
                all.getTabList().removeEntry(player.getUniqueId());
            }
        } else {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (!this.shouldSee(viewer, player)) continue;
                viewer.getTabList().addEntry(this.getEntry(player));
            }
        }
    }

    public RedisGlobalPlayerList(RedisSupport redisSupport, GlobalPlayerList globalPlayerList) {
        this.redisSupport = redisSupport;
        this.globalPlayerList = globalPlayerList;
    }
}

