/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import org.jetbrains.annotations.NotNull;

public class UpdateVanishStatus
extends RedisMessage {
    private UUID playerId;
    private boolean vanished;

    @Override
    public void write(@NotNull ByteArrayDataOutput out) {
        this.writeUUID(out, this.playerId);
        out.writeBoolean(this.vanished);
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in) {
        this.playerId = this.readUUID(in);
        this.vanished = in.readBoolean();
    }

    @Override
    public void process(@NotNull RedisSupport redisSupport) {
        RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
        if (target == null) {
            return;
        }
        target.setVanished(this.vanished);
        redisSupport.getFeatures().forEach(f -> f.onVanishStatusChange(target));
    }

    public UpdateVanishStatus() {
    }

    public UpdateVanishStatus(UUID playerId, boolean vanished) {
        this.playerId = playerId;
        this.vanished = vanished;
    }
}

