/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.types;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import lombok.NonNull;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.placeholders.types.TabPlaceholder;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPlaceholderImpl
extends TabPlaceholder
implements PlayerPlaceholder {
    @NonNull
    private final Function<me.neznamy.tab.api.TabPlayer, Object> function;
    private final Map<TabPlayer, String> lastValues = Collections.synchronizedMap(new WeakHashMap());

    public PlayerPlaceholderImpl(@NonNull String identifier, int refresh, @NonNull Function<me.neznamy.tab.api.TabPlayer, Object> function) {
        super(identifier, refresh);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (identifier.startsWith("%rel_")) {
            throw new IllegalArgumentException("\"rel_\" is reserved for relational placeholder identifiers");
        }
        this.function = function;
    }

    @Override
    public void update(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.updateValue(player, this.request((TabPlayer)player));
    }

    @Override
    public void updateValue(@NonNull me.neznamy.tab.api.TabPlayer player, @Nullable Object value) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.hasValueChanged((TabPlayer)player, value)) {
            if (!player.isLoaded()) {
                return;
            }
            for (Refreshable r : TAB.getInstance().getPlaceholderManager().getPlaceholderUsage(this.identifier)) {
                long startTime = System.nanoTime();
                r.refresh((TabPlayer)player, false);
                TAB.getInstance().getCPUManager().addTime(r.getFeatureName(), r.getRefreshDisplayName(), System.nanoTime() - startTime);
            }
        }
    }

    public boolean hasValueChanged(@NotNull TabPlayer p, @Nullable Object value) {
        if (value == null) {
            return false;
        }
        if ("ERROR".equals(value)) {
            return false;
        }
        String newValue = this.replacements.findReplacement(this.setPlaceholders(String.valueOf(value), p));
        String lastValue = this.lastValues.get(p);
        if (lastValue == null || !this.identifier.equals(newValue) && !newValue.equals(lastValue)) {
            this.lastValues.put(p, newValue);
            this.updateParents(p);
            TAB.getInstance().getPlaceholderManager().getTabExpansion().setPlaceholderValue(p, this.identifier, newValue);
            return true;
        }
        return false;
    }

    @Override
    public void updateFromNested(@NonNull TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.hasValueChanged(player, this.request(player));
    }

    @Override
    @NotNull
    public String getLastValue(@Nullable TabPlayer p) {
        if (p == null) {
            return this.identifier;
        }
        if (!this.lastValues.containsKey(p)) {
            this.lastValues.put(p, this.replacements.findReplacement(this.identifier));
            this.update(p);
        }
        return this.lastValues.get(p);
    }

    @Override
    @NotNull
    public String getLastValueSafe(@NotNull TabPlayer player) {
        return this.lastValues.getOrDefault(player, this.identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        long time = System.currentTimeMillis();
        try {
            Object object = this.function.apply(p);
            return object;
        }
        catch (Throwable t) {
            TAB.getInstance().getErrorManager().placeholderError("Player placeholder " + this.identifier + " generated an error when setting for player " + p.getName(), t);
            String string = "ERROR";
            return string;
        }
        finally {
            long timeDiff = System.currentTimeMillis() - time;
            if (timeDiff > 50L) {
                TAB.getInstance().debug("Placeholder " + this.identifier + " took " + timeDiff + "ms to return value for player " + p.getName());
            }
        }
    }
}

