/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabList<P extends TabPlayer, C> {
    public static final String TEXTURES_PROPERTY = "textures";
    protected final P player;
    protected boolean antiOverride;
    private final Map<TabPlayer, C> expectedDisplayNames = Collections.synchronizedMap(new WeakHashMap());
    private final RedisSupport redisSupport = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
    private final Map<RedisPlayer, C> expectedRedisDisplayNames = Collections.synchronizedMap(new WeakHashMap());
    private C expectedHeader;
    private C expectedFooter;

    public void removeEntries(@NonNull Collection<UUID> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        entries.forEach(this::removeEntry);
    }

    public void addEntries(@NonNull Collection<Entry> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        entries.forEach(this::addEntry);
    }

    public void updateDisplayName(@NonNull UUID entry, @Nullable TabComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        C component = displayName == null ? null : (C)this.toComponent(displayName);
        this.setExpectedDisplayName(entry, component);
        this.updateDisplayName0(entry, component);
    }

    public void addEntry(@NonNull Entry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        C component = entry.displayName == null ? null : (C)this.toComponent(entry.displayName);
        this.setExpectedDisplayName(entry.getUniqueId(), component);
        this.addEntry0(entry.uniqueId, entry.name, entry.skin, entry.listed, entry.latency, entry.gameMode, component);
        if (((TabPlayer)this.player).getVersion().getMinorVersion() == 8) {
            this.updateDisplayName0(entry.getUniqueId(), component);
        }
    }

    public void setPlayerListHeaderFooter(@NonNull TabComponent header, @NonNull TabComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        Object convertedHeader = header.convert(((TabPlayer)this.player).getVersion());
        Object convertedFooter = footer.convert(((TabPlayer)this.player).getVersion());
        this.expectedHeader = convertedHeader;
        this.expectedFooter = convertedFooter;
        this.setPlayerListHeaderFooter0(convertedHeader, convertedFooter);
    }

    public void checkDisplayNames() {
    }

    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
    }

    protected void displayNameWrong(@NonNull String player, @NonNull TabPlayer viewer) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        TAB.getInstance().debug("TabList entry of player " + player + " has a different display name for viewer " + viewer.getName() + " than expected, fixing.");
    }

    private void setExpectedDisplayName(@NonNull UUID entry, @Nullable C displayName) {
        RedisPlayer redisPlayer;
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.antiOverride) {
            return;
        }
        TabPlayer player = TAB.getInstance().getPlayerByTabListUUID(entry);
        if (player != null) {
            this.expectedDisplayNames.put(player, displayName);
        }
        if (this.redisSupport != null && (redisPlayer = this.redisSupport.getRedisPlayers().get(entry)) != null) {
            this.expectedRedisDisplayNames.put(redisPlayer, displayName);
        }
    }

    @Nullable
    public C getExpectedDisplayName(@NotNull UUID id) {
        RedisPlayer redisPlayer;
        if (!this.antiOverride) {
            return null;
        }
        TabPlayer player = TAB.getInstance().getPlayerByTabListUUID(id);
        if (player != null && this.expectedDisplayNames.containsKey(player)) {
            return this.expectedDisplayNames.get(player);
        }
        if (this.redisSupport != null && (redisPlayer = this.redisSupport.getRedisPlayers().get(id)) != null && this.expectedRedisDisplayNames.containsKey(redisPlayer)) {
            return this.expectedRedisDisplayNames.get(redisPlayer);
        }
        return null;
    }

    @Nullable
    protected C getExpectedDisplayName(@NonNull TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.expectedDisplayNames.get(player);
    }

    public C toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return (C)component.convert(((TabPlayer)this.player).getVersion());
    }

    public abstract void removeEntry(@NonNull UUID var1);

    public abstract void updateDisplayName0(@NonNull UUID var1, @Nullable C var2);

    public abstract void updateLatency(@NonNull UUID var1, int var2);

    public abstract void updateGameMode(@NonNull UUID var1, int var2);

    public abstract void updateListed(@NonNull UUID var1, boolean var2);

    public abstract void addEntry0(@NonNull UUID var1, @NonNull String var2, @Nullable Skin var3, boolean var4, int var5, int var6, @Nullable C var7);

    public abstract void setPlayerListHeaderFooter0(@NonNull C var1, @NonNull C var2);

    public abstract boolean containsEntry(@NonNull UUID var1);

    public TabList(P player) {
        this.player = player;
    }

    public void setAntiOverride(boolean antiOverride) {
        this.antiOverride = antiOverride;
    }

    public static class Entry {
        @NonNull
        private UUID uniqueId;
        @NonNull
        private String name = "";
        @Nullable
        private Skin skin;
        private boolean listed;
        private int latency;
        private int gameMode;
        @Nullable
        private TabComponent displayName;

        public Entry(@NonNull UUID uniqueId) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            this.uniqueId = uniqueId;
        }

        public static Entry displayName(@NonNull UUID id, @Nullable TabComponent displayName) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return new Entry(id, "", null, false, 0, 0, displayName);
        }

        public static Entry latency(@NonNull UUID id, int latency) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return new Entry(id, "", null, false, latency, 0, null);
        }

        public static Entry gameMode(@NonNull UUID id, int gameMode) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            return new Entry(id, "", null, false, 0, gameMode, null);
        }

        @NonNull
        public UUID getUniqueId() {
            return this.uniqueId;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public Skin getSkin() {
            return this.skin;
        }

        public boolean isListed() {
            return this.listed;
        }

        public int getLatency() {
            return this.latency;
        }

        public int getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public TabComponent getDisplayName() {
            return this.displayName;
        }

        public void setUniqueId(@NonNull UUID uniqueId) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            this.uniqueId = uniqueId;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        public void setSkin(@Nullable Skin skin) {
            this.skin = skin;
        }

        public void setListed(boolean listed) {
            this.listed = listed;
        }

        public void setLatency(int latency) {
            this.latency = latency;
        }

        public void setGameMode(int gameMode) {
            this.gameMode = gameMode;
        }

        public void setDisplayName(@Nullable TabComponent displayName) {
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isListed() != other.isListed()) {
                return false;
            }
            if (this.getLatency() != other.getLatency()) {
                return false;
            }
            if (this.getGameMode() != other.getGameMode()) {
                return false;
            }
            UUID this$uniqueId = this.getUniqueId();
            UUID other$uniqueId = other.getUniqueId();
            if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Skin this$skin = this.getSkin();
            Skin other$skin = other.getSkin();
            if (this$skin == null ? other$skin != null : !((Object)this$skin).equals(other$skin)) {
                return false;
            }
            TabComponent this$displayName = this.getDisplayName();
            TabComponent other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isListed() ? 79 : 97);
            result = result * 59 + this.getLatency();
            result = result * 59 + this.getGameMode();
            UUID $uniqueId = this.getUniqueId();
            result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Skin $skin = this.getSkin();
            result = result * 59 + ($skin == null ? 43 : ((Object)$skin).hashCode());
            TabComponent $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "TabList.Entry(uniqueId=" + this.getUniqueId() + ", name=" + this.getName() + ", skin=" + this.getSkin() + ", listed=" + this.isListed() + ", latency=" + this.getLatency() + ", gameMode=" + this.getGameMode() + ", displayName=" + this.getDisplayName() + ")";
        }

        public Entry(@NonNull UUID uniqueId, @NonNull String name, @Nullable Skin skin, boolean listed, int latency, int gameMode, @Nullable TabComponent displayName) {
            if (uniqueId == null) {
                throw new NullPointerException("uniqueId is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.uniqueId = uniqueId;
            this.name = name;
            this.skin = skin;
            this.listed = listed;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
        }
    }

    public static class Skin {
        @NonNull
        private final String value;
        @Nullable
        private final String signature;

        @NonNull
        public String getValue() {
            return this.value;
        }

        @Nullable
        public String getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Skin)) {
                return false;
            }
            Skin other = (Skin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Skin;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        public String toString() {
            return "TabList.Skin(value=" + this.getValue() + ", signature=" + this.getSignature() + ")";
        }

        public Skin(@NonNull String value, @Nullable String signature) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            this.signature = signature;
        }
    }

    public static enum Action {
        ADD_PLAYER,
        REMOVE_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME;

    }
}

