/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.event.impl.PlayerLoadEventImpl;
import me.neznamy.tab.shared.features.NickCompatibility;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.features.sorting.Sorting;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.hook.FloodgateHook;
import me.neznamy.tab.shared.placeholders.expansion.PlayerExpansionValues;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.Platform;
import me.neznamy.tab.shared.platform.Scoreboard;
import me.neznamy.tab.shared.platform.TabList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabPlayer
implements me.neznamy.tab.api.TabPlayer {
    protected final Platform platform;
    protected Object player;
    private final String name;
    private String nickname;
    private final UUID uniqueId;
    private final UUID tablistId;
    private String world;
    private String server;
    private String permissionGroup = "NONE";
    private String temporaryGroup;
    private final boolean bedrockPlayer;
    private final Map<String, Property> properties = new HashMap<String, Property>();
    protected final ProtocolVersion version;
    private boolean loaded;
    private boolean online = true;
    public final Sorting.PlayerData sortingData = new Sorting.PlayerData();
    public final ScoreboardManagerImpl.PlayerData scoreboardData = new ScoreboardManagerImpl.PlayerData();
    public final NameTag.PlayerData teamData = new NameTag.PlayerData();
    public final NameTagX.PlayerData unlimitedNametagData = new NameTagX.PlayerData();
    public final LayoutManagerImpl.PlayerData layoutData = new LayoutManagerImpl.PlayerData();
    public final BossBarManagerImpl.PlayerData bossbarData = new BossBarManagerImpl.PlayerData();
    public final PlayerExpansionValues expansionValues = new PlayerExpansionValues();
    public final AtomicBoolean disabledNametags = new AtomicBoolean();
    public final AtomicBoolean disabledUnlimitedNametags = new AtomicBoolean();
    public final AtomicBoolean disabledBelowname = new AtomicBoolean();
    public final AtomicBoolean disabledHeaderFooter = new AtomicBoolean();
    public final AtomicBoolean disabledPlayerList = new AtomicBoolean();
    public final AtomicBoolean disabledYellowNumber = new AtomicBoolean();

    protected TabPlayer(@NotNull Platform platform, @NotNull Object player, @NotNull UUID uniqueId, @NotNull String name, @NotNull String server, @NotNull String world, int protocolVersion, boolean useRealId) {
        this.platform = platform;
        this.player = player;
        this.uniqueId = uniqueId;
        this.name = name;
        this.server = server;
        this.world = world;
        this.nickname = name;
        this.version = ProtocolVersion.fromNetworkId(protocolVersion);
        this.bedrockPlayer = FloodgateHook.getInstance().isFloodgatePlayer(uniqueId, name);
        this.permissionGroup = TAB.getInstance().getGroupManager().detectPermissionGroup(this);
        this.tablistId = useRealId ? uniqueId : UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
    }

    private boolean setProperty(@Nullable Refreshable feature, @NotNull String identifier, @NotNull String rawValue, @Nullable String source, boolean exposeInExpansion) {
        Property p = this.getProperty(identifier);
        if (p == null) {
            this.properties.put(identifier, new Property(exposeInExpansion ? identifier : null, feature, this, rawValue, source));
            return true;
        }
        if (!p.getOriginalRawValue().equals(rawValue)) {
            p.changeRawValue(rawValue, source);
            return true;
        }
        return false;
    }

    public boolean setProperty(@Nullable Refreshable feature, @NotNull String identifier, @NotNull String rawValue) {
        return this.setProperty(feature, identifier, rawValue, null, false);
    }

    public void markAsLoaded(boolean join) {
        this.loaded = true;
        if (TAB.getInstance().getEventBus() != null) {
            TAB.getInstance().getEventBus().fire(new PlayerLoadEventImpl(this, join));
        }
    }

    public void setGroup(@NotNull String permissionGroup) {
        if (this.permissionGroup.equals(permissionGroup)) {
            return;
        }
        this.permissionGroup = permissionGroup;
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%group%"))).updateValue(this, permissionGroup);
        this.forceRefresh();
    }

    @Override
    public void setTemporaryGroup(@Nullable String group) {
        if (Objects.equals(group, this.temporaryGroup)) {
            return;
        }
        this.temporaryGroup = group;
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%group%"))).updateValue(this, group);
        this.forceRefresh();
    }

    @Override
    public boolean hasTemporaryGroup() {
        return this.temporaryGroup != null;
    }

    @Override
    public void setExpectedProfileName(@NonNull String profileName) {
        if (profileName == null) {
            throw new NullPointerException("profileName is marked non-null but is null");
        }
        this.nickname = profileName;
        NickCompatibility nick = (NickCompatibility)TAB.getInstance().getFeatureManager().getFeature("Nick");
        nick.processNameChange(this);
    }

    @Override
    @NotNull
    public String getExpectedProfileName() {
        return this.nickname;
    }

    public void sendMessage(@NotNull String message, boolean translateColors) {
        if (message.isEmpty()) {
            return;
        }
        if (translateColors) {
            this.sendMessage(TabComponent.fromColoredText(message));
        } else {
            this.sendMessage(new SimpleComponent(message));
        }
    }

    public void forceRefresh() {
        if (!this.loaded) {
            return;
        }
        TAB.getInstance().getFeatureManager().refresh(this, true);
    }

    public Property getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    @Override
    @NotNull
    public String getGroup() {
        return this.temporaryGroup != null ? this.temporaryGroup : this.permissionGroup;
    }

    public boolean loadPropertyFromConfig(@Nullable Refreshable feature, @NotNull String property) {
        return this.loadPropertyFromConfig(feature, property, "");
    }

    public boolean loadPropertyFromConfig(@Nullable Refreshable feature, @NotNull String property, @NotNull String ifNotSet) {
        String[] value = TAB.getInstance().getConfiguration().getUsers().getProperty(this.name, property, this.server, this.world);
        if (value.length == 0) {
            value = TAB.getInstance().getConfiguration().getUsers().getProperty(this.uniqueId.toString(), property, this.server, this.world);
        }
        if (value.length == 0) {
            value = TAB.getInstance().getConfiguration().getGroups().getProperty(this.getGroup(), property, this.server, this.world);
        }
        if (value.length > 0) {
            return this.setProperty(feature, property, value[0], value[1], true);
        }
        return this.setProperty(feature, property, ifNotSet, "None", true);
    }

    public void ensureLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("This player is not loaded yet. Try again later");
        }
    }

    public void markOffline() {
        this.online = false;
    }

    @NotNull
    public abstract Scoreboard<? extends TabPlayer, ?> getScoreboard();

    @NotNull
    public abstract BossBar getBossBar();

    public abstract boolean isDisguised();

    public abstract boolean hasInvisibilityPotion();

    public abstract boolean isVanished();

    public abstract int getGamemode();

    public abstract int getPing();

    @Nullable
    public abstract TabList.Skin getSkin();

    @NotNull
    public abstract TabList<?, ?> getTabList();

    public abstract void sendMessage(@NotNull TabComponent var1);

    public abstract boolean hasPermission(@NotNull String var1);

    public abstract Platform getPlatform();

    public void setPlayer(Object player) {
        this.player = player;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public UUID getTablistId() {
        return this.tablistId;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isBedrockPlayer() {
        return this.bedrockPlayer;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isOnline() {
        return this.online;
    }
}

