/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy.features.unlimitedtags;

import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import me.neznamy.tab.shared.proxy.features.unlimitedtags.ProxyArmorStandManager;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.Pause;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.Preview;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.Resume;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.SetEnabled;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.SetText;
import me.neznamy.tab.shared.proxy.message.outgoing.nametags.VisibilityView;
import org.jetbrains.annotations.NotNull;

public class ProxyNameTagX
extends NameTagX {
    public ProxyNameTagX() {
        super(ProxyArmorStandManager::new);
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        super.onServerChange(p, from, to);
        if (p.unlimitedNametagData.previewing) {
            ((ProxyTabPlayer)p).sendPluginMessage(new Preview(true));
        }
        for (String line : this.getDefinedLines()) {
            String text = p.getProperty(line).get();
            ((ProxyTabPlayer)p).sendPluginMessage(new SetText(line, text));
        }
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer changed, @NotNull String from, @NotNull String to) {
        super.onWorldChange(changed, from, to);
        for (String line : this.getDefinedLines()) {
            String text = changed.getProperty(line).get();
            ((ProxyTabPlayer)changed).sendPluginMessage(new SetText(line, text));
        }
    }

    @Override
    public void onUnlimitedDisableConditionChange(TabPlayer p, boolean disabledNow) {
        super.onUnlimitedDisableConditionChange(p, disabledNow);
        ((ProxyTabPlayer)p).sendPluginMessage(new SetEnabled(!disabledNow && !p.disabledNametags.get()));
    }

    @Override
    public void addDisabledPlayer(@NotNull TabPlayer player) {
        super.addDisabledPlayer(player);
        ((ProxyTabPlayer)player).sendPluginMessage(new SetEnabled(false));
    }

    @Override
    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        super.onDisableConditionChange(p, disabledNow);
        ((ProxyTabPlayer)p).sendPluginMessage(new SetEnabled(!disabledNow && !p.disabledUnlimitedNametags.get()));
    }

    @Override
    public boolean isOnBoat(@NotNull TabPlayer player) {
        return ((ProxyTabPlayer)player).isOnBoat();
    }

    @Override
    public void setNameTagPreview(@NotNull TabPlayer player, boolean status) {
        ((ProxyTabPlayer)player).sendPluginMessage(new Preview(status));
    }

    @Override
    public void resumeArmorStands(@NotNull TabPlayer player) {
        ((ProxyTabPlayer)player).sendPluginMessage(new Resume());
    }

    @Override
    public void pauseArmorStands(@NotNull TabPlayer player) {
        ((ProxyTabPlayer)player).sendPluginMessage(new Pause());
    }

    @Override
    public void updateNameTagVisibilityView(@NotNull TabPlayer player) {
        ((ProxyTabPlayer)player).sendPluginMessage(new VisibilityView());
    }
}

