/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy.message.incoming;

import com.google.common.io.ByteArrayDataInput;
import java.util.HashMap;
import java.util.Map;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.api.placeholder.RelationalPlaceholder;
import me.neznamy.tab.api.placeholder.ServerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.types.TabPlaceholder;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import me.neznamy.tab.shared.proxy.message.incoming.IncomingMessage;
import org.jetbrains.annotations.NotNull;

public class PlayerJoinResponse
implements IncomingMessage {
    private String world;
    private String group;
    private Map<String, Object> placeholders;
    private int gameMode;

    @Override
    public void read(@NotNull ByteArrayDataInput in) {
        this.world = in.readUTF();
        if (TAB.getInstance().getGroupManager().getPermissionPlugin().contains("Vault") && !TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
            this.group = in.readUTF();
        }
        this.placeholders = new HashMap<String, Object>();
        int placeholderCount = in.readInt();
        for (int i = 0; i < placeholderCount; ++i) {
            String identifier = in.readUTF();
            if (identifier.startsWith("%rel_")) {
                HashMap<String, String> map = new HashMap<String, String>();
                int playerCount = in.readInt();
                for (int j = 0; j < playerCount; ++j) {
                    String otherPlayer = in.readUTF();
                    String value = in.readUTF();
                    map.put(otherPlayer, value);
                }
                this.placeholders.put(identifier, map);
                continue;
            }
            this.placeholders.put(identifier, in.readUTF());
        }
        this.gameMode = in.readInt();
    }

    @Override
    public void process(@NotNull ProxyTabPlayer player) {
        TAB.getInstance().debug("Bridge took " + (System.currentTimeMillis() - player.getBridgeRequestTime()) + "ms to respond to join message of " + player.getName());
        TAB.getInstance().getFeatureManager().onWorldChange(player.getUniqueId(), this.world);
        if (this.group != null) {
            player.setGroup(this.group);
        }
        if (player.vanished) {
            player.vanished = false;
            TAB.getInstance().getFeatureManager().onVanishStatusChange(player);
        }
        player.setDisguised(false);
        player.setInvisibilityPotion(false);
        for (Map.Entry<String, Object> entry : this.placeholders.entrySet()) {
            String identifier = entry.getKey();
            if (!TAB.getInstance().getPlaceholderManager().isPlaceholderRegistered(identifier)) continue;
            if (identifier.startsWith("%rel_")) {
                Map map = (Map)entry.getValue();
                for (Map.Entry entry2 : map.entrySet()) {
                    TabPlayer other = TAB.getInstance().getPlayer((String)entry2.getKey());
                    if (other == null) continue;
                    ((RelationalPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier))).updateValue(player, other, entry2.getValue());
                }
                continue;
            }
            TabPlaceholder pl = TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier);
            if (pl instanceof PlayerPlaceholder) {
                ((PlayerPlaceholder)((Object)pl)).updateValue(player, entry.getValue());
                continue;
            }
            ((ServerPlaceholder)((Object)pl)).updateValue(entry.getValue());
        }
        player.setGamemode(this.gameMode);
        player.setBridgeConnected(true);
    }
}

