/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy.message.outgoing;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.proxy.message.outgoing.OutgoingMessage;
import org.jetbrains.annotations.NotNull;

public class PlayerJoin
implements OutgoingMessage {
    private int protocolVersion;
    private boolean forwardGroup;
    private Map<String, Integer> placeholders;
    private Map<String, Map<Object, Object>> replacements;
    private UnlimitedNametagSettings unlimitedNameTags;

    @Override
    @NotNull
    public ByteArrayDataOutput write() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerJoin");
        out.writeInt(this.protocolVersion);
        out.writeBoolean(this.forwardGroup);
        out.writeInt(this.placeholders.size());
        for (Map.Entry<String, Integer> entry : this.placeholders.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(entry.getValue().intValue());
        }
        out.writeInt(this.replacements.size());
        for (Map.Entry<String, Object> entry : this.replacements.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(((Map)entry.getValue()).size());
            for (Map.Entry rule : ((Map)entry.getValue()).entrySet()) {
                out.writeUTF(EnumChatFormat.color(String.valueOf(rule.getKey())));
                out.writeUTF(EnumChatFormat.color(String.valueOf(rule.getValue())));
            }
        }
        out.writeBoolean(this.unlimitedNameTags != null);
        if (this.unlimitedNameTags != null) {
            out.writeBoolean(this.unlimitedNameTags.disableOnBoats);
            out.writeBoolean(this.unlimitedNameTags.alwaysVisible);
            out.writeBoolean(this.unlimitedNameTags.isDisabledForPlayer);
            out.writeInt(this.unlimitedNameTags.dynamicLines.size());
            for (String string : this.unlimitedNameTags.dynamicLines) {
                out.writeUTF(string);
            }
            out.writeInt(this.unlimitedNameTags.staticLines.size());
            for (Map.Entry<String, Object> entry : this.unlimitedNameTags.staticLines.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeDouble(Double.parseDouble(String.valueOf(entry.getValue())));
            }
        }
        return out;
    }

    public PlayerJoin(int protocolVersion, boolean forwardGroup, Map<String, Integer> placeholders, Map<String, Map<Object, Object>> replacements, UnlimitedNametagSettings unlimitedNameTags) {
        this.protocolVersion = protocolVersion;
        this.forwardGroup = forwardGroup;
        this.placeholders = placeholders;
        this.replacements = replacements;
        this.unlimitedNameTags = unlimitedNameTags;
    }

    public static class UnlimitedNametagSettings {
        private boolean disableOnBoats;
        private boolean alwaysVisible;
        private boolean isDisabledForPlayer;
        private List<String> dynamicLines;
        private Map<String, Object> staticLines;

        public UnlimitedNametagSettings(boolean disableOnBoats, boolean alwaysVisible, boolean isDisabledForPlayer, List<String> dynamicLines, Map<String, Object> staticLines) {
            this.disableOnBoats = disableOnBoats;
            this.alwaysVisible = alwaysVisible;
            this.isDisabledForPlayer = isDisabledForPlayer;
            this.dynamicLines = dynamicLines;
            this.staticLines = staticLines;
        }
    }
}

