/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.neznamy.tab.shared.ProtocolVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentCache<K, V> {
    private final int cacheSize;
    private final BiFunction<K, ProtocolVersion, V> function;
    private final Map<K, V> cacheModern = new HashMap();
    private final Map<K, V> cacheLegacy = new HashMap();

    @NotNull
    public V get(@NotNull K key, @Nullable ProtocolVersion clientVersion) {
        Map<Object, Object> cache;
        Map<Object, Object> map = cache = clientVersion == null || clientVersion.supportsRGB() ? this.cacheModern : this.cacheLegacy;
        if (cache.size() > this.cacheSize) {
            cache.clear();
        }
        return (V)cache.computeIfAbsent(key, k -> this.function.apply(k, clientVersion));
    }

    public ComponentCache(int cacheSize, BiFunction<K, ProtocolVersion, V> function) {
        this.cacheSize = cacheSize;
        this.function = function;
    }
}

