/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.fabric.network;

import java.util.List;
import java.util.function.Consumer;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.network.Packets;
import net.bettercombat.network.ServerNetwork;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;

public class FabricServerNetwork {
    public static void init() {
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.ConfigSync.ID)) {
                System.out.println("Starting ConfigurationTask");
                handler.addTask((class_8605)new ConfigurationTask(Packets.ConfigSync.serialize(BetterCombatMod.config)));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: bettercombat:config"));
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.WeaponRegistrySync.ID)) {
                if (WeaponRegistry.getEncodedRegistry().chunks().isEmpty()) {
                    throw new AssertionError((Object)"Weapon registry is empty!");
                }
                System.out.println("Starting WeaponRegistrySyncTask, chunks: " + WeaponRegistry.getEncodedRegistry().chunks().size());
                handler.addTask((class_8605)new WeaponRegistrySyncTask(WeaponRegistry.getEncodedRegistry().chunks()));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: bettercombat:weapon_registry"));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver((class_2960)Packets.Ack.ID, (server, handler, buf, responseSender) -> {
            Packets.Ack packet = Packets.Ack.read(buf);
            if (packet.code().equals("bettercombat:config")) {
                handler.completeTask(ConfigurationTask.KEY);
            }
            if (packet.code().equals("bettercombat:weapon_registry")) {
                handler.completeTask(WeaponRegistrySyncTask.KEY);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.AttackAnimation.ID, (server, player, handler, buf, responseSender) -> {
            Packets.AttackAnimation packet = Packets.AttackAnimation.read(buf);
            ServerNetwork.handleAttackAnimation(packet, server, player);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.C2S_AttackRequest.ID, (server, player, handler, buf, responseSender) -> {
            Packets.C2S_AttackRequest packet = Packets.C2S_AttackRequest.read(buf);
            ServerNetwork.handleAttackRequest(packet, server, player, handler);
        });
    }

    public record ConfigurationTask(String configString) implements class_8605
    {
        public static final String name = "bettercombat:config";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("bettercombat:config");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            class_2540 buffer = PacketByteBufs.create();
            new Packets.ConfigSync(this.configString).method_53028(buffer);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_2960)Packets.ConfigSync.ID, (class_2540)buffer));
        }
    }

    public record WeaponRegistrySyncTask(List<String> encodedRegistry) implements class_8605
    {
        public static final String name = "bettercombat:weapon_registry";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("bettercombat:weapon_registry");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            class_2540 buffer = PacketByteBufs.create();
            new Packets.WeaponRegistrySync(this.encodedRegistry).method_53028(buffer);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_2960)Packets.WeaponRegistrySync.ID, (class_2540)buffer));
        }
    }
}

