/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.utils.AuthHelper;
import xyz.nikitacartes.easyauth.utils.PlayerAuth;
import xyz.nikitacartes.easyauth.utils.TranslationHelper;

public class AccountCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"account").requires(Permissions.require((String)"easyauth.commands.account.root", (boolean)true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unregister").requires(Permissions.require((String)"easyauth.commands.account.unregister", (boolean)true))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9207().method_7353(TranslationHelper.getEnterPassword(), false);
            return 1;
        })).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> AccountCommand.unregister((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"password")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"changePassword").requires(Permissions.require((String)"easyauth.commands.account.changePassword", (boolean)true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"old password", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9207().method_7353(TranslationHelper.getEnterNewPassword(), false);
            return 1;
        })).then(class_2170.method_9244((String)"new password", (ArgumentType)StringArgumentType.string()).executes(ctx -> AccountCommand.changePassword((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"old password"), StringArgumentType.getString((CommandContext)ctx, (String)"new password")))))));
    }

    private static int unregister(class_2168 source, String pass) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (EasyAuth.config.main.enableGlobalPassword) {
            player.method_7353(TranslationHelper.getCannotUnregister(), false);
            return 0;
        }
        EasyAuth.THREADPOOL.submit(() -> {
            String uuid = ((PlayerAuth)player).easyAuth$getFakeUuid();
            if (AuthHelper.checkPassword(uuid, pass.toCharArray()) == AuthHelper.PasswordOptions.CORRECT) {
                EasyAuth.DB.deleteUserData(uuid);
                player.method_7353(TranslationHelper.getAccountDeleted(), false);
                ((PlayerAuth)player).easyAuth$setAuthenticated(false);
                player.field_13987.method_52396(TranslationHelper.getAccountDeleted());
                EasyAuth.playerCacheMap.remove(uuid);
                return;
            }
            player.method_7353(TranslationHelper.getWrongPassword(), false);
        });
        return 0;
    }

    private static int changePassword(class_2168 source, String oldPass, String newPass) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (EasyAuth.config.main.enableGlobalPassword) {
            player.method_7353(TranslationHelper.getCannotChangePassword(), false);
            return 0;
        }
        EasyAuth.THREADPOOL.submit(() -> {
            if (AuthHelper.checkPassword(((PlayerAuth)player).easyAuth$getFakeUuid(), oldPass.toCharArray()) == AuthHelper.PasswordOptions.CORRECT) {
                if (newPass.length() < EasyAuth.config.main.minPasswordChars) {
                    player.method_7353(TranslationHelper.getMinPasswordChars(), false);
                    return;
                }
                if (newPass.length() > EasyAuth.config.main.maxPasswordChars && EasyAuth.config.main.maxPasswordChars != -1) {
                    player.method_7353(TranslationHelper.getMaxPasswordChars(), false);
                    return;
                }
                EasyAuth.playerCacheMap.get((Object)((PlayerAuth)player).easyAuth$getFakeUuid()).password = AuthHelper.hashPassword(newPass.toCharArray());
                player.method_7353(TranslationHelper.getPasswordUpdated(), false);
            } else {
                player.method_7353(TranslationHelper.getWrongPassword(), false);
            }
        });
        return 0;
    }
}

