/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.mixin;

import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.event.AuthEventHandler;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.utils.EasyLogger;
import xyz.nikitacartes.easyauth.utils.FloodgateApiHelper;
import xyz.nikitacartes.easyauth.utils.PlayerAuth;
import xyz.nikitacartes.easyauth.utils.TranslationHelper;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityMixin
implements PlayerAuth {
    @Unique
    private final class_3222 player = (class_3222)this;
    @Final
    @Shadow
    public MinecraftServer field_13995;
    @Unique
    private int kickTimer;

    public ServerPlayerEntityMixin() {
        this.kickTimer = EasyAuth.config.main.kickTime * 20;
    }

    @Override
    public void easyAuth$hidePosition(boolean hide) {
        PlayerCache cache = EasyAuth.playerCacheMap.get(this.easyAuth$getFakeUuid());
        EasyLogger.LogDebug(String.format("Teleporting player %s to %s", this.player.method_5477().method_10851(), hide ? "spawn." : "position."));
        if (hide) {
            cache.lastLocation.dimension = this.player.method_51469();
            cache.lastLocation.position = this.player.method_19538();
            cache.lastLocation.yaw = this.player.method_36454();
            cache.lastLocation.pitch = this.player.method_36455();
            cache.ridingEntityUUID = this.player.method_5854() != null ? this.player.method_5854().method_5667() : null;
            EasyLogger.LogDebug(String.format("Saving position of player %s", cache.lastLocation));
            EasyLogger.LogDebug(String.format("Saving vehicle of player %s", cache.ridingEntityUUID));
            this.player.method_14251(this.field_13995.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(EasyAuth.config.worldSpawn.dimension))), EasyAuth.config.worldSpawn.x, EasyAuth.config.worldSpawn.y, EasyAuth.config.worldSpawn.z, EasyAuth.config.worldSpawn.yaw, EasyAuth.config.worldSpawn.pitch);
            return;
        }
        this.player.method_14251(cache.lastLocation.dimension, cache.lastLocation.position.method_10216(), cache.lastLocation.position.method_10214(), cache.lastLocation.position.method_10215(), cache.lastLocation.yaw, cache.lastLocation.pitch);
        EasyLogger.LogDebug(String.format("Teleported player to %s", cache.lastLocation));
        if (cache.ridingEntityUUID != null) {
            EasyLogger.LogDebug(String.format("Mounting player to vehicle %s", cache.ridingEntityUUID));
            class_3218 world = this.field_13995.method_3847(cache.lastLocation.dimension.method_27983());
            if (world == null) {
                return;
            }
            class_1297 entity = world.method_14190(cache.ridingEntityUUID);
            if (entity != null) {
                this.player.method_5873(entity, true);
            } else {
                EasyLogger.LogDebug("Could not find vehicle for player " + this.player.method_5477().method_10851());
            }
        }
    }

    @Override
    public String easyAuth$getFakeUuid() {
        assert (this.field_13995 != null);
        if (this.field_13995.method_3828() && this.easyAuth$isUsingMojangAccount() && !EasyAuth.config.experimental.forcedOfflineUuids) {
            return this.player.method_5845();
        }
        String playername = this.player.method_7334().getName().toLowerCase();
        return class_4844.method_43344((String)playername).toString();
    }

    @Override
    public class_2561 easyAuth$getAuthMessage() {
        PlayerCache cache = EasyAuth.playerCacheMap.get(((PlayerAuth)this.player).easyAuth$getFakeUuid());
        if (!EasyAuth.config.main.enableGlobalPassword && (cache == null || cache.password.isEmpty())) {
            if (EasyAuth.config.experimental.enableServerSideTranslation) {
                return class_2561.method_43471((String)"text.easyauth.notAuthenticated").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"text.easyauth.registerRequired"));
            }
            return class_2561.method_30163((String)(EasyAuth.config.lang.notAuthenticated + "\n" + EasyAuth.config.lang.registerRequired));
        }
        if (EasyAuth.config.experimental.enableServerSideTranslation) {
            return class_2561.method_43471((String)"text.easyauth.notAuthenticated").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"text.easyauth.loginRequired"));
        }
        return class_2561.method_30163((String)(EasyAuth.config.lang.notAuthenticated + "\n" + EasyAuth.config.lang.loginRequired));
    }

    @Override
    public boolean easyAuth$canSkipAuth() {
        return this.player.getClass() != class_3222.class || EasyAuth.config.main.floodgateAutologin && EasyAuth.config.experimental.floodgateLoaded && FloodgateApiHelper.isFloodgatePlayer((class_1657)this.player) || this.easyAuth$isUsingMojangAccount() && EasyAuth.config.main.premiumAutologin;
    }

    @Override
    public boolean easyAuth$isUsingMojangAccount() {
        return this.field_13995.method_3828() && EasyAuth.mojangAccountNamesCache.contains(this.player.method_7334().getName().toLowerCase());
    }

    @Override
    public boolean easyAuth$isAuthenticated() {
        String uuid = ((PlayerAuth)this.player).easyAuth$getFakeUuid();
        return this.easyAuth$canSkipAuth() || EasyAuth.playerCacheMap.containsKey(uuid) && EasyAuth.playerCacheMap.get((Object)uuid).isAuthenticated;
    }

    @Override
    public void easyAuth$setAuthenticated(boolean authenticated) {
        PlayerCache playerCache = EasyAuth.playerCacheMap.get(this.easyAuth$getFakeUuid());
        playerCache.isAuthenticated = authenticated;
        this.player.method_5684(!authenticated && EasyAuth.config.experimental.playerInvulnerable);
        this.player.method_5648(!authenticated && EasyAuth.config.experimental.playerInvisible);
        if (EasyAuth.config.main.spawnOnJoin) {
            this.easyAuth$hidePosition(!authenticated);
        }
        if (authenticated) {
            this.kickTimer = EasyAuth.config.main.kickTime * 20;
            if (playerCache.wasInPortal) {
                class_1937 world = this.player.method_5770();
                class_2338 pos = this.player.method_24515();
                world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
                world.method_8413(pos.method_10084(), world.method_8320(pos.method_10084()), world.method_8320(pos.method_10084()), 3);
            }
        }
    }

    @Inject(method={"playerTick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void playerTick(CallbackInfo ci) {
        if (!this.easyAuth$isAuthenticated()) {
            if (this.kickTimer <= 0 && this.player.field_13987.method_48106()) {
                this.player.field_13987.method_52396(TranslationHelper.getTimeExpired());
            } else if (!EasyAuth.playerCacheMap.containsKey(((PlayerAuth)this.player).easyAuth$getFakeUuid())) {
                this.player.field_13987.method_52396(TranslationHelper.getAccountDeleted());
            } else {
                if (this.kickTimer % 200 == 0) {
                    this.player.method_7353(this.easyAuth$getAuthMessage(), false);
                }
                --this.kickTimer;
            }
            ci.cancel();
        }
    }

    @Inject(method={"dropSelectedItem(Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void dropSelectedItem(boolean dropEntireStack, CallbackInfoReturnable<Boolean> cir) {
        class_1269 result = AuthEventHandler.onDropItem((class_1657)this.player);
        if (result == class_1269.field_5814) {
            cir.setReturnValue((Object)false);
        }
    }
}

