/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.utils;

import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.utils.EasyLogger;
import xyz.nikitacartes.easyauth.utils.hashing.HasherArgon2;
import xyz.nikitacartes.easyauth.utils.hashing.HasherBCrypt;

public class AuthHelper {
    public static PasswordOptions checkPassword(String uuid, char[] password) {
        String hashed = EasyAuth.playerCacheMap.get((Object)uuid).password;
        if (EasyAuth.config.experimental.debugMode) {
            EasyLogger.LogDebug("Checking password for " + uuid);
            EasyLogger.LogDebug("Stored password's hash: " + hashed);
            EasyLogger.LogDebug("Hashed password: " + AuthHelper.hashPassword(password));
        }
        if (EasyAuth.config.main.enableGlobalPassword) {
            char[] passwordCopy = (char[])password.clone();
            return AuthHelper.verifyPassword(password, EasyAuth.config.main.globalPassword) || !hashed.isEmpty() && AuthHelper.verifyPassword(passwordCopy, hashed) ? PasswordOptions.CORRECT : PasswordOptions.WRONG;
        }
        if (hashed.isEmpty()) {
            return PasswordOptions.NOT_REGISTERED;
        }
        return AuthHelper.verifyPassword(password, hashed) ? PasswordOptions.CORRECT : PasswordOptions.WRONG;
    }

    public static String hashPassword(char[] password) {
        if (EasyAuth.config.experimental.useBCryptLibrary) {
            return HasherBCrypt.hash(password);
        }
        return HasherArgon2.hash(password);
    }

    private static boolean verifyPassword(char[] pass, String hashed) {
        if (EasyAuth.config.experimental.useBCryptLibrary) {
            return HasherBCrypt.verify(pass, hashed);
        }
        return HasherArgon2.verify(pass, hashed);
    }

    public static enum PasswordOptions {
        CORRECT,
        WRONG,
        NOT_REGISTERED;

    }
}

