/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7701;
import net.minecraft.class_7784;
import net.minecraft.class_7788;
import net.minecraft.class_7789;
import net.minecraft.class_7791;
import net.minecraft.class_7923;
import net.minecraft.class_8488;
import net.minecraft.class_8489;
import net.minecraft.class_8490;
import net.minecraft.class_8564;
import net.minecraft.class_8942;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class AbstractLootProviderV2 {
    private AbstractLootProviderV2() {
    }

    public static interface LootTableDataProvider
    extends class_2405 {
        public void method_10399(BiConsumer<class_2960, class_52.class_53> var1);

        public class_7784.class_7489 pathProvider();

        public class_176 paramSet();

        public boolean skipValidationFor(class_2960 var1);

        default public CompletableFuture<?> method_10319(class_7403 output) {
            HashMap<class_2960, class_52> lootTables = new HashMap<class_2960, class_52>();
            Object2ObjectOpenHashMap seeds = new Object2ObjectOpenHashMap();
            this.method_10399((arg_0, arg_1) -> this.lambda$run$0((Map)seeds, lootTables, arg_0, arg_1));
            this.validate(lootTables);
            return CompletableFuture.allOf((CompletableFuture[])lootTables.entrySet().stream().map(entry -> {
                class_2960 resourceLocation = (class_2960)entry.getKey();
                class_52 lootTable = (class_52)entry.getValue();
                Path path = this.pathProvider().method_44107(resourceLocation);
                return class_2405.method_53496((class_7403)output, (Codec)class_52.field_45796, (Object)lootTable, (Path)path);
            }).toArray(CompletableFuture[]::new));
        }

        default public void validate(final Map<class_2960, class_52> tables) {
            class_8942.class_8943 collector = new class_8942.class_8943();
            class_58 validationContext = new class_58((class_8942)collector, class_173.field_1177, new class_8489(){

                @Nullable
                public <T> T getElement(class_8488<T> lootDataId) {
                    if (lootDataId.comp_1474() == class_8490.field_44498) {
                        class_52 lootTable = this.skipValidationFor(lootDataId.comp_1475()) ? class_52.method_324().method_338() : (class_52)tables.get(lootDataId.comp_1475());
                        return (T)lootTable;
                    }
                    return null;
                }
            });
            tables.forEach((resourceLocation, lootTable) -> this.validate((class_2960)resourceLocation, (class_52)lootTable, validationContext));
            Multimap multimap = collector.method_54948();
            if (!multimap.isEmpty()) {
                multimap.forEach((string, string2) -> field_40831.warn("Found validation problem in {}: {}", string, string2));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
        }

        default public void validate(class_2960 resourceLocation, class_52 lootTable, class_58 validationContext) {
            if (!this.skipValidationFor(resourceLocation)) {
                lootTable.method_330(validationContext.method_22568(lootTable.method_322()).method_51219("{" + resourceLocation + "}", new class_8488(class_8490.field_44498, resourceLocation)));
            }
        }

        private /* synthetic */ void lambda$run$0(Map seeds, Map lootTables, class_2960 resourceLocation, class_52.class_53 builder) {
            class_2960 resourceLocation2 = seeds.put(class_8564.method_52171((class_2960)resourceLocation), resourceLocation);
            if (resourceLocation2 != null) {
                field_40831.error("Loot table random sequence seed collision on " + resourceLocation2 + " and " + resourceLocation);
            }
            builder.method_51883(resourceLocation);
            if (lootTables.put(resourceLocation, builder.method_334(this.paramSet()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }
    }

    public static abstract class Simple
    implements class_7791,
    LootTableDataProvider {
        private final Map<class_2960, class_52.class_53> tables = new HashMap<class_2960, class_52.class_53>();
        private final Set<class_2960> skipValidation = Sets.newHashSet();
        private final class_176 paramSet;
        private final class_7784.class_7489 pathProvider;

        public Simple(class_176 paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput());
        }

        public Simple(class_176 paramSet, class_7784 packOutput) {
            this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables");
            this.paramSet = paramSet;
        }

        public String method_10321() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        @Override
        public void method_10399(BiConsumer<class_2960, class_52.class_53> exporter) {
            this.addLootTables();
            this.tables.forEach(exporter);
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return this.paramSet;
        }

        @Override
        public boolean skipValidationFor(class_2960 resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        protected void add(class_2960 table, class_52.class_53 builder) {
            this.tables.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends class_7789
    implements LootTableDataProvider {
        private final Set<class_2960> skipValidation = Sets.newHashSet();
        private final class_7784.class_7489 pathProvider;
        private final String modId;

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public EntityTypes(String modId, class_7784 packOutput) {
            super(class_7701.field_40180.method_45383());
            this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables");
            this.modId = modId;
        }

        public String method_10321() {
            return "Entity Type Loot Tables";
        }

        public final void method_10400() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        @Override
        public void method_10399(BiConsumer<class_2960, class_52.class_53> consumer) {
            this.method_10400();
            HashSet set = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                class_1299 entityType = (class_1299)holder.comp_349();
                Map map = (Map)this.field_40615.remove(entityType);
                if (this.canHaveLootTable(entityType)) {
                    class_2960 lootTableLocation = entityType.method_16351();
                    if (!(lootTableLocation.equals((Object)class_39.field_844) || map != null && map.containsKey(lootTableLocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", lootTableLocation, holder.method_40237().method_29177()));
                    }
                    if (map != null) {
                        map.forEach((resourceLocation, builder) -> {
                            if (!set.add(resourceLocation)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocation, holder.method_40237().method_29177()));
                            }
                            consumer.accept((class_2960)resourceLocation, (class_52.class_53)builder);
                        });
                    }
                } else if (map != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(class_2960::toString).collect(Collectors.joining(",")), holder.method_40237().method_29177()));
                }
            });
            if (!this.field_40615.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + this.field_40615.keySet());
            }
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return class_173.field_1173;
        }

        @Override
        public boolean skipValidationFor(class_2960 resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        public void skipValidation(class_1299<?> entityType) {
            this.skipValidation(entityType.method_16351());
        }

        protected boolean canHaveLootTable(class_1299<?> entityType) {
            return entityType.method_5891() != class_1311.field_17715;
        }

        protected Stream<class_6880.class_6883<class_1299<?>>> getRegistryEntries() {
            return class_7923.field_41177.method_40270().filter(holder -> holder.method_40237().method_29177().method_12836().equals(this.modId));
        }
    }

    public static abstract class Blocks
    extends class_7788
    implements LootTableDataProvider {
        private final Set<class_2960> skipValidation = Sets.newHashSet();
        private final class_7784.class_7489 pathProvider;
        private final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public Blocks(String modId, class_7784 packOutput) {
            super(Collections.emptySet(), class_7701.field_40180.method_45383());
            this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables");
            this.modId = modId;
        }

        public String method_10321() {
            return "Block Loot Tables";
        }

        public final void method_10379() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        @Override
        public void method_10399(BiConsumer<class_2960, class_52.class_53> consumer) {
            this.method_10379();
            HashSet set = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                class_2960 lootTableLocation = ((class_2248)holder.comp_349()).method_26162();
                if (lootTableLocation != class_39.field_844 && set.add(lootTableLocation)) {
                    class_52.class_53 builder = (class_52.class_53)this.field_40610.remove(lootTableLocation);
                    if (builder == null) {
                        throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(lootTableLocation, holder.method_40237().method_29177()));
                    }
                    consumer.accept(lootTableLocation, builder);
                }
            });
            if (!this.field_40610.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_40610.keySet());
            }
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return class_173.field_1172;
        }

        @Override
        public boolean skipValidationFor(class_2960 resourceLocation) {
            return this.skipValidation.contains(resourceLocation);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation.add(resourceLocation);
        }

        public void skipValidation(class_2248 block) {
            this.skipValidation(block.method_26162());
        }

        public void dropNothing(class_2248 block) {
            this.method_45988(block, Blocks.method_45975());
        }

        public void dropNameable(class_2248 block) {
            this.method_45994(block, arg_0 -> ((Blocks)this).method_45996(arg_0));
        }

        protected Stream<class_6880.class_6883<class_2248>> getRegistryEntries() {
            return class_7923.field_41175.method_40270().filter(holder -> holder.method_40237().method_29177().method_12836().equals(this.modId));
        }
    }
}

