/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV3 {
    public static Builder builder(String modId) {
        return NetworkHandlerV3.builder(new class_2960(modId, "main"));
    }

    public static Builder builder(class_2960 channelName) {
        return ModContext.get(channelName.method_12836()).getNetworkHandlerV3(channelName);
    }

    public <T extends Record> class_2596<class_8705> toClientboundPacket(T var1);

    public <T extends Record> class_2596<class_8706> toServerboundPacket(T var1);

    default public <T extends Record> void sendMessage(PlayerSet playerSet, T message) {
        playerSet.notify(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendMessage(T message) {
        class_634 clientPacketListener = Proxy.INSTANCE.getClientPacketListener();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        clientPacketListener.method_52787(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendToServer(T message) {
        this.sendMessage(message);
    }

    default public <T extends Record> void sendTo(class_3222 player, T message) {
        Objects.requireNonNull(player, "player is null");
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, T message) {
        this.sendToAll(server, null, message);
    }

    default public <T extends Record> void sendToAll(MinecraftServer server, @Nullable class_3222 exclude, T message) {
        Objects.requireNonNull(server, "server is null");
        this.sendToAll(server.method_3760().method_14571(), exclude, message);
    }

    default public <T extends Record> void sendToAll(Collection<class_3222> playerList, @Nullable class_3222 exclude, T message) {
        Objects.requireNonNull(playerList, "player list is null");
        for (class_3222 player : playerList) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAll(class_3218 level, T message) {
        Objects.requireNonNull(level, "level is null");
        for (class_3222 player : level.method_18456()) {
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAllNear(class_2382 pos, class_3218 level, T message) {
        Objects.requireNonNull(pos, "pos is null");
        this.sendToAllNear(pos.method_10263(), pos.method_10264(), pos.method_10260(), level, message);
    }

    default public <T extends Record> void sendToAllNear(double posX, double posY, double posZ, class_3218 level, T message) {
        this.sendToAllNear(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNear(@Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_3218 level, T message) {
        Objects.requireNonNull(level, "level is null");
        level.method_8503().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(class_2586 blockEntity, T message) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        class_1937 level = blockEntity.method_10997();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.field_9236 ? 1 : 0) != 0, (Object)"block entity level is client level");
        this.sendToAllNear((class_2382)blockEntity.method_11016(), (class_3218)level, message);
    }

    default public <T extends Record> void sendToAllTracking(class_2818 chunk, T message) {
        Objects.requireNonNull(chunk, "chunk is null");
        Preconditions.checkState((!chunk.method_12200().field_9236 ? 1 : 0) != 0, (Object)"chunk level is client level");
        this.sendToAllTracking((class_3218)chunk.method_12200(), chunk.method_12004(), message);
    }

    default public <T extends Record> void sendToAllTracking(class_3218 level, class_1923 chunkPos, T message) {
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        List players = level.method_14178().field_17254.method_17210(chunkPos, false);
        this.sendToAll(players, null, message);
    }

    default public <T extends Record> void sendToAllTracking(class_1297 entity, T message, boolean includeSelf) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.method_5770().field_9236 ? 1 : 0) != 0, (Object)"entity level is client level");
        class_3215 chunkSource = ((class_3218)entity.method_5770()).method_14178();
        if (includeSelf) {
            chunkSource.method_18751(entity, this.toClientboundPacket(message));
        } else {
            chunkSource.method_18754(entity, this.toClientboundPacket(message));
        }
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    Buildable {
        default public <T> Builder registerSerializer(Class<T> type, class_2540.class_7462<T> writer, class_2540.class_7461<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, class_5321<class_2378<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder optional();
    }
}

