/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingBreathEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingTickCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LookingAtEndermanCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LootingLevelCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ContainerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.GrindstoneEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PickupExperienceCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlayLevelSoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelperV2;
import fuzs.puzzleslib.fabric.api.event.v1.FabricEntityEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLevelEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLifecycleEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricPlayerEvents;
import fuzs.puzzleslib.fabric.api.event.v1.core.FabricEventInvokerRegistry;
import fuzs.puzzleslib.fabric.impl.client.event.FabricClientEventInvokers;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import net.minecraft.class_2828;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5658;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FabricEventInvokerRegistryImpl
implements FabricEventInvokerRegistry {
    public static void registerLoadingHandlers() {
        INSTANCE.register(RegistryEntryAddedCallback.class, FabricEventInvokerRegistryImpl::onRegistryEntryAdded);
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            FabricClientEventInvokers.registerLoadingHandlers();
        } else {
            INSTANCE.register(LoadCompleteCallback.class, FabricLifecycleEvents.SERVER_LOAD_COMPLETE);
        }
    }

    private static <T> void onRegistryEntryAdded(RegistryEntryAddedCallback<T> callback, @Nullable Object context) {
        Objects.requireNonNull(context, "context is null");
        class_5321 resourceKey = (class_5321)context;
        class_2378 registry = RegistryHelperV2.findBuiltInRegistry(resourceKey);
        BiConsumer<class_2960, Supplier> registrar = (resourceLocation, supplier) -> class_2378.method_10230((class_2378)registry, (class_2960)resourceLocation, supplier.get());
        net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback.event(registry).register((rawId, id, object) -> callback.onRegistryEntryAdded(registry, id, object, registrar));
        LinkedHashMap toRegister = Maps.newLinkedHashMap();
        for (Map.Entry entry : registry.method_29722()) {
            callback.onRegistryEntryAdded(registry, ((class_5321)entry.getKey()).method_29177(), entry.getValue(), toRegister::put);
        }
        toRegister.forEach(registrar);
    }

    public static void registerEventHandlers() {
        INSTANCE.register(TagsUpdatedCallback.class, CommonLifecycleEvents.TAGS_LOADED, (T callback) -> callback::onTagsUpdated);
        INSTANCE.register(RegisterCommandsCallback.class, CommandRegistrationCallback.EVENT, (T callback) -> callback::onRegisterCommands);
        INSTANCE.register(ServerLifecycleEvents.Starting.class, ServerLifecycleEvents.SERVER_STARTING, (T callback) -> callback::onServerStarting);
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, UseBlockCallback.EVENT, (T callback) -> (player, level, hand, hitResult) -> {
            EventResultHolder<class_1269> result = callback.onUseBlock(player, level, hand, hitResult);
            return result.getInterrupt().map(interactionResult -> {
                if (interactionResult == class_1269.field_5811) {
                    interactionResult = class_1269.field_5814;
                }
                if (level.field_9236 && interactionResult != class_1269.field_5812) {
                    ((FabricProxy)Proxy.INSTANCE).startClientPrediction(level, id -> new class_2885(hand, hitResult, id));
                }
                return interactionResult;
            }).orElse(class_1269.field_5811);
        });
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, AttackBlockCallback.EVENT, (T callback) -> (player, level, hand, pos, direction) -> {
            if (!level.field_9236 || player.method_7337() || ((FabricProxy)Proxy.INSTANCE).shouldStartDestroyBlock(pos)) {
                EventResult result = callback.onAttackBlock(player, level, hand, pos, direction);
                return result.isInterrupt() ? class_1269.field_5812 : class_1269.field_5811;
            }
            return class_1269.field_5811;
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, UseItemCallback.EVENT, (T callback) -> (player, level, hand) -> {
            if (player.method_7325()) {
                return class_1271.method_22430((Object)class_1799.field_8037);
            }
            if (player.method_7357().method_7904(player.method_5998(hand).method_7909())) {
                return class_1271.method_22430((Object)class_1799.field_8037);
            }
            EventResultHolder<class_1269> result = callback.onUseItem(player, level, hand);
            return new class_1271(result.getInterrupt().map(interactionResult -> {
                if (interactionResult == class_1269.field_5811) {
                    interactionResult = class_1269.field_5814;
                }
                if (level.field_9236 && interactionResult != class_1269.field_5812) {
                    Proxy.INSTANCE.getClientPacketListener().method_52787((class_2596)new class_2828.class_2830(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_24828()));
                    ((FabricProxy)Proxy.INSTANCE).startClientPrediction(level, id -> new class_2886(hand, id));
                }
                return interactionResult;
            }).orElse(class_1269.field_5811), (Object)class_1799.field_8037);
        });
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, UseEntityCallback.EVENT, (T callback) -> (player, level, hand, entity, hitResult) -> {
            if (hitResult != null) {
                return class_1269.field_5811;
            }
            EventResultHolder<class_1269> result = callback.onUseEntity(player, level, hand, entity);
            return result.getInterrupt().map(interactionResult -> {
                if (interactionResult == class_1269.field_5811) {
                    interactionResult = class_1269.field_5814;
                }
                if (level.field_9236 && interactionResult == class_1269.field_5814) {
                    Proxy.INSTANCE.getClientPacketListener().method_52787((class_2596)class_2824.method_34207((class_1297)entity, (boolean)player.method_5715(), (class_1268)hand));
                }
                return interactionResult;
            }).orElse(class_1269.field_5811);
        });
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, UseEntityCallback.EVENT, (T callback) -> (player, level, hand, entity, hitResult) -> {
            if (hitResult == null) {
                return class_1269.field_5811;
            }
            EventResultHolder<class_1269> result = callback.onUseEntityAt(player, level, hand, entity, hitResult.method_17784());
            return result.getInterrupt().map(interactionResult -> {
                if (interactionResult == class_1269.field_5811) {
                    interactionResult = class_1269.field_5814;
                }
                if (level.field_9236 && interactionResult == class_1269.field_5814) {
                    Proxy.INSTANCE.getClientPacketListener().method_52787((class_2596)class_2824.method_34208((class_1297)entity, (boolean)player.method_5715(), (class_1268)hand, (class_243)hitResult.method_17784()));
                }
                return interactionResult;
            }).orElse(class_1269.field_5811);
        });
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityCallback.EVENT, (T callback) -> (player, level, hand, entity, hitResult) -> {
            EventResult result = callback.onAttackEntity(player, level, hand, entity);
            return result.isInterrupt() ? class_1269.field_5812 : class_1269.field_5811;
        });
        INSTANCE.register(PickupExperienceCallback.class, FabricPlayerEvents.PICKUP_XP);
        INSTANCE.register(BonemealCallback.class, FabricPlayerEvents.BONEMEAL);
        INSTANCE.register(LivingExperienceDropCallback.class, FabricLivingEvents.EXPERIENCE_DROP);
        INSTANCE.register(BlockEvents.Break.class, PlayerBlockBreakEvents.BEFORE, (T callback) -> (level, player, pos, state, blockEntity) -> {
            EventResult result = callback.onBreakBlock((class_3218)level, pos, state, player, player.method_6047());
            return result.isPass();
        });
        INSTANCE.register(BlockEvents.DropExperience.class, FabricLevelEvents.DROP_BLOCK_EXPERIENCE);
        INSTANCE.register(BlockEvents.FarmlandTrample.class, FabricLevelEvents.FARMLAND_TRAMPLE);
        INSTANCE.register(PlayerTickEvents.Start.class, FabricPlayerEvents.PLAYER_TICK_START);
        INSTANCE.register(PlayerTickEvents.End.class, FabricPlayerEvents.PLAYER_TICK_END);
        INSTANCE.register(LivingFallCallback.class, FabricLivingEvents.LIVING_FALL);
        INSTANCE.register(LootTableLoadEvents.Replace.class, LootTableEvents.REPLACE, (T callback) -> (resourceManager, lootManager, id, original, source) -> {
            DefaultedValue<class_52> lootTable = DefaultedValue.fromValue(original);
            callback.onReplaceLootTable(id, lootTable);
            return lootTable.getAsOptional().orElse(null);
        });
        INSTANCE.register(LootTableLoadEvents.Modify.class, LootTableEvents.MODIFY, (T callback) -> (resourceManager, lootManager, id, tableBuilder, source) -> callback.onModifyLootTable(lootManager, id, arg_0 -> ((class_52.class_53)tableBuilder).pool(arg_0), index -> {
            MutableInt currentIndex = new MutableInt();
            MutableBoolean result = new MutableBoolean();
            tableBuilder.modifyPools(builder -> {
                if (index == currentIndex.getAndIncrement()) {
                    builder.method_352((class_5658)class_44.method_32448((float)0.0f));
                    builder.method_35509((class_5658)class_44.method_32448((float)0.0f));
                    result.setTrue();
                }
            });
            return result.booleanValue();
        }));
        INSTANCE.register(AnvilEvents.Use.class, FabricPlayerEvents.ANVIL_USE);
        INSTANCE.register(ItemEntityEvents.Touch.class, FabricPlayerEvents.ITEM_TOUCH);
        INSTANCE.register(ItemEntityEvents.Pickup.class, FabricPlayerEvents.ITEM_PICKUP);
        INSTANCE.register(LootingLevelCallback.class, FabricLivingEvents.LOOTING_LEVEL);
        INSTANCE.register(AnvilEvents.Update.class, FabricPlayerEvents.ANVIL_UPDATE);
        INSTANCE.register(LivingDropsCallback.class, FabricLivingEvents.LIVING_DROPS);
        INSTANCE.register(LivingTickCallback.class, FabricLivingEvents.LIVING_TICK);
        INSTANCE.register(ArrowLooseCallback.class, FabricPlayerEvents.ARROW_LOOSE);
        INSTANCE.register(LivingHurtCallback.class, FabricLivingEvents.LIVING_HURT);
        INSTANCE.register(UseItemEvents.Start.class, FabricLivingEvents.USE_ITEM_START);
        INSTANCE.register(UseItemEvents.Tick.class, FabricLivingEvents.USE_ITEM_TICK);
        INSTANCE.register(UseItemEvents.Stop.class, FabricLivingEvents.USE_ITEM_STOP);
        INSTANCE.register(UseItemEvents.Finish.class, FabricLivingEvents.USE_ITEM_FINISH);
        INSTANCE.register(ShieldBlockCallback.class, FabricLivingEvents.SHIELD_BLOCK);
        INSTANCE.register(ExplosionEvents.Start.class, FabricLevelEvents.EXPLOSION_START);
        INSTANCE.register(ExplosionEvents.Detonate.class, FabricLevelEvents.EXPLOSION_DETONATE);
        INSTANCE.register(SyncDataPackContentsCallback.class, ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS, (T callback) -> callback::onSyncDataPackContents);
        INSTANCE.register(ServerLifecycleEvents.Started.class, ServerLifecycleEvents.SERVER_STARTED, (T callback) -> callback::onServerStarted);
        INSTANCE.register(ServerLifecycleEvents.Stopping.class, ServerLifecycleEvents.SERVER_STOPPING, (T callback) -> callback::onServerStopping);
        INSTANCE.register(ServerLifecycleEvents.Stopped.class, ServerLifecycleEvents.SERVER_STOPPED, (T callback) -> callback::onServerStopped);
        INSTANCE.register(PlayLevelSoundEvents.AtPosition.class, FabricLevelEvents.PLAY_LEVEL_SOUND_AT_POSITION);
        INSTANCE.register(PlayLevelSoundEvents.AtEntity.class, FabricLevelEvents.PLAY_LEVEL_SOUND_AT_ENTITY);
        INSTANCE.register(ServerEntityLevelEvents.Load.class, FabricEntityEvents.ENTITY_LOAD);
        INSTANCE.register(ServerEntityLevelEvents.Spawn.class, FabricEntityEvents.ENTITY_SPAWN);
        INSTANCE.register(ServerEntityLevelEvents.Unload.class, ServerEntityEvents.ENTITY_UNLOAD, (T callback) -> callback::onEntityUnload);
        INSTANCE.register(LivingDeathCallback.class, FabricLivingEvents.LIVING_DEATH);
        INSTANCE.register(PlayerTrackingEvents.Start.class, FabricPlayerEvents.START_TRACKING);
        INSTANCE.register(PlayerTrackingEvents.Stop.class, EntityTrackingEvents.STOP_TRACKING, (T callback) -> callback::onStopTracking);
        INSTANCE.register(PlayerNetworkEvents.LoggedIn.class, ServerPlayConnectionEvents.JOIN, (T callback) -> (handler, sender, server) -> callback.onLoggedIn(handler.method_32311()));
        INSTANCE.register(PlayerNetworkEvents.LoggedOut.class, ServerPlayConnectionEvents.DISCONNECT, (T callback) -> (handler, server) -> callback.onLoggedOut(handler.method_32311()));
        INSTANCE.register(AfterChangeDimensionCallback.class, ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD, (T callback) -> callback::onAfterChangeDimension);
        INSTANCE.register(BabyEntitySpawnCallback.class, FabricLivingEvents.BABY_ENTITY_SPAWN);
        INSTANCE.register(AnimalTameCallback.class, FabricLivingEvents.ANIMAL_TAME);
        INSTANCE.register(LivingAttackCallback.class, FabricLivingEvents.LIVING_ATTACK);
        INSTANCE.register(PlayerCopyEvents.Copy.class, ServerPlayerEvents.COPY_FROM, (T callback) -> callback::onCopy);
        INSTANCE.register(PlayerCopyEvents.Respawn.class, ServerPlayerEvents.AFTER_RESPAWN, (T callback) -> (oldPlayer, newPlayer, alive) -> callback.onRespawn(newPlayer, alive));
        INSTANCE.register(ServerTickEvents.Start.class, ServerTickEvents.START_SERVER_TICK, (T callback) -> callback::onStartServerTick);
        INSTANCE.register(ServerTickEvents.End.class, ServerTickEvents.END_SERVER_TICK, (T callback) -> callback::onEndServerTick);
        INSTANCE.register(ServerLevelTickEvents.Start.class, ServerTickEvents.START_WORLD_TICK, (T callback) -> level -> callback.onStartLevelTick(level.method_8503(), level));
        INSTANCE.register(ServerLevelTickEvents.End.class, ServerTickEvents.END_WORLD_TICK, (T callback) -> level -> callback.onEndLevelTick(level.method_8503(), level));
        INSTANCE.register(ServerLevelEvents.Load.class, ServerWorldEvents.LOAD, (T callback) -> callback::onLevelLoad);
        INSTANCE.register(ServerLevelEvents.Unload.class, ServerWorldEvents.UNLOAD, (T callback) -> callback::onLevelUnload);
        INSTANCE.register(ServerChunkEvents.Load.class, ServerChunkEvents.CHUNK_LOAD, (T callback) -> callback::onChunkLoad);
        INSTANCE.register(ServerChunkEvents.Unload.class, ServerChunkEvents.CHUNK_UNLOAD, (T callback) -> callback::onChunkUnload);
        INSTANCE.register(ItemEntityEvents.Toss.class, FabricPlayerEvents.ITEM_TOSS);
        INSTANCE.register(LivingKnockBackCallback.class, FabricLivingEvents.LIVING_KNOCK_BACK);
        INSTANCE.register(ItemAttributeModifiersCallback.class, ModifyItemAttributeModifiersCallback.EVENT, (T callback) -> callback::onItemAttributeModifiers);
        INSTANCE.register(ProjectileImpactCallback.class, FabricEntityEvents.PROJECTILE_IMPACT);
        INSTANCE.register(BreakSpeedCallback.class, FabricPlayerEvents.BREAK_SPEED);
        INSTANCE.register(MobEffectEvents.Affects.class, FabricLivingEvents.MOB_EFFECT_AFFECTS);
        INSTANCE.register(MobEffectEvents.Apply.class, FabricLivingEvents.MOB_EFFECT_APPLY);
        INSTANCE.register(MobEffectEvents.Remove.class, FabricLivingEvents.MOB_EFFECT_REMOVE);
        INSTANCE.register(MobEffectEvents.Expire.class, FabricLivingEvents.MOB_EFFECT_EXPIRE);
        INSTANCE.register(LivingJumpCallback.class, FabricLivingEvents.LIVING_JUMP);
        INSTANCE.register(LivingVisibilityCallback.class, FabricLivingEvents.LIVING_VISIBILITY);
        INSTANCE.register(LivingChangeTargetCallback.class, FabricLivingEvents.LIVING_CHANGE_TARGET);
        INSTANCE.register(CheckMobDespawnCallback.class, FabricLivingEvents.CHECK_MOB_DESPAWN);
        INSTANCE.register(GatherPotentialSpawnsCallback.class, FabricLevelEvents.GATHER_POTENTIAL_SPAWNS);
        INSTANCE.register(EntityRidingEvents.Start.class, FabricEntityEvents.ENTITY_START_RIDING);
        INSTANCE.register(EntityRidingEvents.Stop.class, FabricEntityEvents.ENTITY_STOP_RIDING);
        INSTANCE.register(GrindstoneEvents.Update.class, FabricPlayerEvents.GRINDSTONE_UPDATE);
        INSTANCE.register(GrindstoneEvents.Use.class, FabricPlayerEvents.GRINDSTONE_USE);
        INSTANCE.register(LivingBreathEvents.Breathe.class, FabricLivingEvents.LIVING_BREATHE);
        INSTANCE.register(LivingBreathEvents.Drown.class, FabricLivingEvents.LIVING_DROWN);
        INSTANCE.register(ServerChunkEvents.Watch.class, FabricLevelEvents.WATCH_CHUNK);
        INSTANCE.register(ServerChunkEvents.Unwatch.class, FabricLevelEvents.UNWATCH_CHUNK);
        INSTANCE.register(LivingEquipmentChangeCallback.class, FabricLivingEvents.LIVING_EQUIPMENT_CHANGE);
        INSTANCE.register(LivingConversionCallback.class, ServerLivingEntityEvents.MOB_CONVERSION, (T callback) -> (previous, converted, keepEquipment) -> callback.onLivingConversion((class_1309)previous, (class_1309)converted));
        INSTANCE.register(ContainerEvents.Open.class, FabricPlayerEvents.CONTAINER_OPEN);
        INSTANCE.register(ContainerEvents.Close.class, FabricPlayerEvents.CONTAINER_CLOSE);
        INSTANCE.register(LookingAtEndermanCallback.class, FabricLivingEvents.LOOKING_AT_ENDERMAN);
        if (ModLoaderEnvironment.INSTANCE.isClient()) {
            FabricClientEventInvokers.registerEventHandlers();
        }
    }

    @Override
    public <T, E> void register(Class<T> clazz, Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter, boolean joinInvokers) {
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(event, "event is null");
        Objects.requireNonNull(converter, "converter is null");
        EventInvokerImpl.register(clazz, new FabricEventInvoker<T, E>(event, converter, eventPhaseConverter), joinInvokers);
    }

    @Override
    public <T, E> void register(Class<T> clazz, Class<E> eventType, Function<T, E> converter, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, UnaryOperator<EventPhase> eventPhaseConverter, boolean joinInvokers) {
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(eventType, "event type is null");
        Objects.requireNonNull(converter, "converter is null");
        Objects.requireNonNull(consumer, "consumer is null");
        EventInvokerImpl.register(clazz, new FabricForwardingEventInvoker<Object, Object>((callback, context) -> converter.apply(callback), consumer, eventPhaseConverter), joinInvokers);
    }

    private record FabricEventInvoker<T, E>(Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter, Set<EventPhase> knownEventPhases) implements EventInvoker<T>,
    EventInvokerImpl.EventInvokerLike<T>
    {
        public FabricEventInvoker(Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter) {
            this(event, converter, eventPhaseConverter, Collections.synchronizedSet(Sets.newIdentityHashSet()));
        }

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return context != null ? (phase, callback) -> this.register(phase, callback, context) : this;
        }

        @Override
        public void register(EventPhase phase, T callback) {
            this.register(phase, callback, null);
        }

        private void register(EventPhase phase, T callback, @Nullable Object context) {
            Objects.requireNonNull(phase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            phase = (EventPhase)this.eventPhaseConverter.apply(phase);
            if (phase.parent() == null) {
                this.event.register(this.converter.apply(callback, context));
            } else {
                this.testEventPhase(phase);
                this.event.register(phase.identifier(), this.converter.apply(callback, context));
            }
        }

        private void testEventPhase(EventPhase phase) {
            Stack<EventPhase> stack = new Stack<EventPhase>();
            while (phase.parent() != null && !this.knownEventPhases.contains(phase)) {
                stack.push(phase);
                phase = phase.parent();
            }
            while (!stack.isEmpty()) {
                phase = (EventPhase)stack.pop();
                phase.applyOrdering((arg_0, arg_1) -> this.event.addPhaseOrdering(arg_0, arg_1));
                this.knownEventPhases.add(phase);
            }
        }
    }

    private record FabricForwardingEventInvoker<T, E>(Function<Event<E>, EventInvoker<T>> factory, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, Map<Event<E>, EventInvoker<T>> events) implements EventInvokerImpl.EventInvokerLike<T>
    {
        public FabricForwardingEventInvoker(FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, UnaryOperator<EventPhase> eventPhaseConverter) {
            this((Event<E> event) -> new FabricEventInvoker(event, converter, eventPhaseConverter), consumer, new MapMaker().weakKeys().concurrencyLevel(1).makeMap());
        }

        @Override
        public EventInvoker<T> asEventInvoker(@NotNull Object context) {
            Objects.requireNonNull(context, "context is null");
            return (phase, callback) -> this.consumer.accept(context, event -> this.events.computeIfAbsent((Event<E>)event, this.factory).register(phase, callback), this.events::remove);
        }
    }
}

