/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_8705;
import net.minecraft.class_8706;

public class NetworkHandlerFabricV2
implements NetworkHandlerV2 {
    private final Map<Class<? extends MessageV2<?>>, Map.Entry<class_2960, class_2598>> messageNames = Maps.newIdentityHashMap();
    private final AtomicInteger discriminator = new AtomicInteger();
    private final class_2960 channelName;

    public NetworkHandlerFabricV2(class_2960 channelName) {
        this.channelName = channelName;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> clazz, Function<class_2540, T> factory) {
        class_2960 channelName = this.registerMessageType(clazz, class_2598.field_11942);
        ((FabricProxy)Proxy.INSTANCE).registerLegacyClientReceiver(channelName, factory);
        return this;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> clazz, Function<class_2540, T> factory) {
        class_2960 channelName = this.registerMessageType(clazz, class_2598.field_11941);
        ((FabricProxy)Proxy.INSTANCE).registerLegacyServerReceiver(channelName, factory);
        return this;
    }

    private class_2960 registerMessageType(Class<? extends MessageV2<?>> clazz, class_2598 packetFlow) {
        class_2960 messageName = new class_2960(this.channelName.method_42094(), String.valueOf(this.discriminator.getAndIncrement()));
        this.messageNames.put(clazz, Map.entry(messageName, packetFlow));
        return messageName;
    }

    @Override
    public class_2596<class_8705> toClientboundPacket(MessageV2<?> message) {
        if (this.messageNames.get(message.getClass()).getValue() == class_2598.field_11941) {
            String modName = ModLoaderEnvironment.INSTANCE.getModContainer(this.channelName.method_12836()).map(ModContainer::getDisplayName).orElse(this.channelName.method_12836());
            throw new IllegalStateException("Sending %s from %s on wrong side!".formatted(message.getClass().getSimpleName(), modName));
        }
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    @Override
    public class_2596<class_8706> toServerboundPacket(MessageV2<?> message) {
        if (this.messageNames.get(message.getClass()).getValue() == class_2598.field_11942) {
            String modName = ModLoaderEnvironment.INSTANCE.getModContainer(this.channelName.method_12836()).map(ModContainer::getDisplayName).orElse(this.channelName.method_12836());
            throw new IllegalStateException("Sending %s from %s on wrong side!".formatted(message.getClass().getSimpleName(), modName));
        }
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    private <T extends class_2547> class_2596<T> toPacket(BiFunction<class_2960, class_2540, class_2596<T>> packetFactory, MessageV2<?> message) {
        class_2960 identifier = this.messageNames.get(message.getClass()).getKey();
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return packetFactory.apply(identifier, byteBuf);
    }
}

