/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin.client;

import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.fabric.api.client.event.v1.ExtraScreenMouseEvents;
import fuzs.puzzleslib.fabric.api.client.event.v1.FabricClientEvents;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_312.class}, priority=500)
abstract class MouseHandlerFabricMixin {
    @Shadow
    @Final
    private class_310 field_1779;
    @Shadow
    private double field_1795;
    @Shadow
    private double field_1794;
    @Shadow
    private int field_1780;
    @Unique
    private class_437 puzzleslib$currentScreen;
    @Unique
    private Double puzzleslib$verticalScrollAmount;
    @Unique
    private Double puzzleslib$horizontalScrollAmount;

    MouseHandlerFabricMixin() {
    }

    @Inject(method={"onPress"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getOverlay()Lnet/minecraft/client/gui/screens/Overlay;", ordinal=0)}, cancellable=true)
    private void onPress$0(long windowPointer, int button, int action, int modifiers, CallbackInfo callback) {
        EventResult result = ((InputEvents.BeforeMouseAction)FabricClientEvents.BEFORE_MOUSE_ACTION.invoker()).onBeforeMouseAction(button, action, modifiers);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"onPress"}, at={@At(value="TAIL")})
    private void onPress$1(long windowPointer, int button, int action, int modifiers, CallbackInfo callback) {
        if (windowPointer == class_310.method_1551().method_22683().method_4490()) {
            ((InputEvents.AfterMouseAction)FabricClientEvents.AFTER_MOUSE_ACTION.invoker()).onAfterMouseAction(button, action, modifiers);
        }
    }

    @Inject(method={"onScroll"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z")}, cancellable=true)
    private void onScroll$0(long windowPointer, double xOffset, double yOffset, CallbackInfo callback) {
        this.puzzleslib$verticalScrollAmount = (Boolean)this.field_1779.field_1690.method_42439().method_41753() != false ? Math.signum(yOffset) : yOffset * (Double)this.field_1779.field_1690.method_41806().method_41753();
        this.puzzleslib$horizontalScrollAmount = (Boolean)this.field_1779.field_1690.method_42439().method_41753() != false ? Math.signum(xOffset) : xOffset * (Double)this.field_1779.field_1690.method_41806().method_41753();
        if (((InputEvents.BeforeMouseScroll)FabricClientEvents.BEFORE_MOUSE_SCROLL.invoker()).onBeforeMouseScroll(this.method_1608(), this.method_35707(), this.method_1609(), this.puzzleslib$horizontalScrollAmount, this.puzzleslib$verticalScrollAmount).isInterrupt()) {
            this.puzzleslib$verticalScrollAmount = null;
            this.puzzleslib$horizontalScrollAmount = null;
            callback.cancel();
        }
    }

    @Inject(method={"onScroll"}, at={@At(value="TAIL")})
    private void onScroll$1(long windowPointer, double xOffset, double yOffset, CallbackInfo callback) {
        if (windowPointer == class_310.method_1551().method_22683().method_4490() && this.field_1779.method_18506() == null && this.field_1779.field_1755 == null && this.field_1779.field_1724 != null) {
            Objects.requireNonNull(this.puzzleslib$verticalScrollAmount, "vertical scroll amount is null");
            Objects.requireNonNull(this.puzzleslib$horizontalScrollAmount, "horizontal scroll amount is null");
            ((InputEvents.AfterMouseScroll)FabricClientEvents.AFTER_MOUSE_SCROLL.invoker()).onAfterMouseScroll(this.method_1608(), this.method_35707(), this.method_1609(), this.puzzleslib$horizontalScrollAmount, this.puzzleslib$verticalScrollAmount);
            this.puzzleslib$verticalScrollAmount = null;
            this.puzzleslib$horizontalScrollAmount = null;
        }
    }

    @Shadow
    public abstract boolean method_1608();

    @Shadow
    public abstract boolean method_35707();

    @Shadow
    public abstract boolean method_1609();

    @Inject(method={"lambda$onMove$11(Lnet/minecraft/client/gui/screens/Screen;DDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void lambda$onMove$11$0(class_437 screen, double mouseX, double mouseY, double dragX, double dragY, CallbackInfo callback) {
        this.puzzleslib$currentScreen = this.field_1779.field_1755;
        if (this.puzzleslib$currentScreen == null) {
            return;
        }
        if (!((ExtraScreenMouseEvents.AllowMouseDrag)ExtraScreenMouseEvents.allowMouseDrag(this.puzzleslib$currentScreen).invoker()).allowMouseDrag(this.puzzleslib$currentScreen, mouseX, mouseY, this.field_1780, dragX, dragY)) {
            this.puzzleslib$currentScreen = null;
            callback.cancel();
            return;
        }
        ((ExtraScreenMouseEvents.BeforeMouseDrag)ExtraScreenMouseEvents.beforeMouseDrag(this.puzzleslib$currentScreen).invoker()).beforeMouseDrag(this.puzzleslib$currentScreen, mouseX, mouseY, this.field_1780, dragX, dragY);
    }

    @Inject(method={"lambda$onMove$11(Lnet/minecraft/client/gui/screens/Screen;DDDD)V"}, at={@At(value="TAIL")})
    private void lambda$onMove$11$1(class_437 screen, double mouseX, double mouseY, double dragX, double dragY, CallbackInfo callback) {
        if (this.puzzleslib$currentScreen == null) {
            return;
        }
        ((ExtraScreenMouseEvents.AfterMouseDrag)ExtraScreenMouseEvents.afterMouseDrag(this.puzzleslib$currentScreen).invoker()).afterMouseDrag(this.puzzleslib$currentScreen, mouseX, mouseY, this.field_1780, dragX, dragY);
        this.puzzleslib$currentScreen = null;
    }
}

