/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.init.v3.MinecartTypeRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public final class MinecartTypeRegistryImpl
implements MinecartTypeRegistry {
    private static final Map<class_1688.class_1689, MinecartTypeRegistry.Factory> MINECART_FACTORIES = Collections.synchronizedMap(Maps.newIdentityHashMap());

    @Override
    public void register(class_1688.class_1689 type, MinecartTypeRegistry.Factory factory) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(factory, "factory is null");
        MINECART_FACTORIES.put(type, factory);
    }

    public static Optional<class_1688> createMinecartForType(@Nullable class_1688.class_1689 type, class_1937 level, double x, double y, double z) {
        if (type != null && MINECART_FACTORIES.containsKey(type)) {
            return Optional.of(MINECART_FACTORIES.get(type)).map(factory -> factory.create(level, x, y, z));
        }
        return Optional.empty();
    }
}

