/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer;

import com.mojang.authlib.GameProfile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.lionarius.skinrestorer.config.Config;
import net.lionarius.skinrestorer.skin.SkinIO;
import net.lionarius.skinrestorer.skin.SkinStorage;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.skin.provider.SkinProviderRegistry;
import net.lionarius.skinrestorer.translation.Translation;
import net.lionarius.skinrestorer.util.FileUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkinRestorer {
    public static final String MOD_ID = "skinrestorer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SkinRestorer");
    private static final SkinProviderRegistry providersRegistry = new SkinProviderRegistry();
    private static SkinStorage skinStorage;
    private static Path configDir;
    private static Config config;

    private SkinRestorer() {
    }

    public static SkinStorage getSkinStorage() {
        return skinStorage;
    }

    public static Path getConfigDir() {
        return configDir;
    }

    public static Config getConfig() {
        return config;
    }

    public static SkinProviderRegistry getProvidersRegistry() {
        return providersRegistry;
    }

    public static Optional<SkinProvider> getProvider(String name) {
        return Optional.ofNullable(providersRegistry.get(name));
    }

    public static void onInitialize(Path rootConfigDir) {
        configDir = rootConfigDir.resolve(MOD_ID);
        SkinRestorer.reloadConfig();
        providersRegistry.register("empty", SkinProvider.EMPTY, false);
        providersRegistry.register("mojang", SkinProvider.MOJANG);
        providersRegistry.register("ely.by", SkinProvider.ELY_BY);
        providersRegistry.register("web", SkinProvider.MINESKIN);
    }

    public static void onServerStarted(MinecraftServer server) {
        Path worldSkinDirectory = server.method_27050(class_5218.field_24188).resolve(MOD_ID);
        FileUtils.tryMigrateOldSkinDirectory(worldSkinDirectory);
        skinStorage = new SkinStorage(new SkinIO(worldSkinDirectory));
    }

    public static void reloadConfig() {
        config = Config.load(SkinRestorer.getConfigDir());
        Translation.reloadTranslations();
    }

    public static String resource(String name) {
        return String.format("/assets/%s/%s", MOD_ID, name);
    }

    public static Collection<class_3222> applySkin(MinecraftServer server, Iterable<GameProfile> targets, SkinValue value, boolean save) {
        HashSet<class_3222> acceptedPlayers = new HashSet<class_3222>();
        for (GameProfile profile : targets) {
            if (!SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
                value = value.setOriginalValue(PlayerUtils.getPlayerSkin(profile));
            }
            if (save) {
                SkinRestorer.getSkinStorage().setSkin(profile.getId(), value);
            }
            if (PlayerUtils.areSkinPropertiesEquals(value.value(), PlayerUtils.getPlayerSkin(profile))) continue;
            PlayerUtils.applyRestoredSkin(profile, value.value());
            class_3222 player = server.method_3760().method_14602(profile.getId());
            if (player == null) continue;
            PlayerUtils.refreshPlayer(player);
            acceptedPlayers.add(player);
        }
        return acceptedPlayers;
    }

    public static Collection<class_3222> applySkin(MinecraftServer server, Iterable<GameProfile> targets, SkinValue value) {
        return SkinRestorer.applySkin(server, targets, value, true);
    }

    public static CompletableFuture<Result<Collection<class_3222>, String>> setSkinAsync(MinecraftServer server, Collection<GameProfile> targets, SkinProviderContext context, boolean save) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SkinRestorer.getProvider(context.name()).map(provider -> provider.getSkin(context.argument(), context.variant()))).thenApplyAsync(result -> {
            if (result.isEmpty()) {
                return Result.error("provider '" + context.name() + "' is not registered");
            }
            Result skinResult = (Result)result.get();
            if (skinResult.isError()) {
                return Result.error(((Exception)skinResult.getErrorValue()).getMessage());
            }
            SkinValue skinValue = SkinValue.fromProviderContextWithValue(context, ((Optional)skinResult.getSuccessValue()).orElse(null));
            Collection<class_3222> acceptedPlayers = SkinRestorer.applySkin(server, targets, skinValue, save);
            return Result.success(acceptedPlayers);
        }, (Executor)server)).exceptionally(e -> {
            LOGGER.error(e.toString());
            return Result.error(e.getMessage());
        });
    }
}

