/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.config;

import java.nio.file.Path;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.util.FileUtils;
import net.lionarius.skinrestorer.util.JsonUtils;

public final class Config {
    public static final String CONFIG_FILENAME = "config.json";
    private String language = "en_us";
    private boolean fetchSkinOnFirstJoin = true;
    private String proxy = "";
    private long requestTimeout = 10L;

    public String getLanguage() {
        return this.language;
    }

    public boolean fetchSkinOnFirstJoin() {
        return this.fetchSkinOnFirstJoin;
    }

    public String getProxy() {
        return this.proxy;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public static Config load(Path path) {
        Path configFile = path.resolve(CONFIG_FILENAME);
        Config config = null;
        try {
            config = JsonUtils.fromJson(FileUtils.readFile(configFile), Config.class);
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.warn("Could not load config", (Throwable)e);
        }
        if (config == null) {
            config = new Config();
        }
        FileUtils.writeFile(path.resolve(CONFIG_FILENAME), JsonUtils.toJson(config));
        return config;
    }
}

