/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.CompletableFuture;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.minecraft.class_3248;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class})
public abstract class ServerLoginPacketListenerImplMixin {
    @Shadow
    @Nullable
    private GameProfile field_45029;
    @Unique
    private CompletableFuture<Void> skinrestorer_pendingSkin;

    @Inject(method={"verifyLoginAndFinishConnectionSetup"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;")}, cancellable=true)
    public void waitForSkin(CallbackInfo ci) {
        if (this.skinrestorer_pendingSkin == null) {
            this.skinrestorer_pendingSkin = CompletableFuture.supplyAsync(() -> {
                assert (this.field_45029 != null);
                Property originalSkin = PlayerUtils.getPlayerSkin(this.field_45029);
                if (SkinRestorer.getSkinStorage().hasSavedSkin(this.field_45029.getId())) {
                    if (originalSkin != null) {
                        SkinValue value = SkinRestorer.getSkinStorage().getSkin(this.field_45029.getId());
                        SkinRestorer.getSkinStorage().setSkin(this.field_45029.getId(), value.setOriginalValue(originalSkin));
                    }
                    return null;
                }
                if (originalSkin == null && SkinRestorer.getConfig().fetchSkinOnFirstJoin()) {
                    SkinRestorer.LOGGER.debug("Fetching {}'s skin", (Object)this.field_45029.getName());
                    SkinProviderContext context = new SkinProviderContext("mojang", this.field_45029.getName(), null);
                    Result result = SkinRestorer.getProvider(context.name()).map(provider -> provider.getSkin(context.argument(), context.variant())).orElse(Result.ofNullable(null));
                    if (!result.isError()) {
                        SkinValue value = SkinValue.fromProviderContextWithValue(context, result.getSuccessValue().orElse(null));
                        SkinRestorer.getSkinStorage().setSkin(this.field_45029.getId(), value);
                    } else {
                        SkinRestorer.LOGGER.warn("failed to fetch skin on first join", (Throwable)result.getErrorValue());
                    }
                }
                return null;
            });
        }
        if (!this.skinrestorer_pendingSkin.isDone()) {
            ci.cancel();
        }
    }
}

