/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import org.jetbrains.annotations.NotNull;

public final class SkinProviderRegistry {
    private final Map<String, Entry> registry = new HashMap<String, Entry>();

    public SkinProvider get(String name) {
        Entry entry = this.registry.get(name);
        if (entry == null) {
            return null;
        }
        return entry.provider;
    }

    public Collection<Pair<String, SkinProvider>> getProviders() {
        return this.registry.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Entry)entry.getValue()).provider)).toList();
    }

    public Collection<Pair<String, SkinProvider>> getPublicProviders() {
        return this.registry.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).isPublic).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Entry)entry.getValue()).provider)).toList();
    }

    public void register(@NotNull String name, @NotNull SkinProvider provider) {
        this.register(name, provider, true);
    }

    public void register(@NotNull String name, @NotNull SkinProvider provider, boolean isPublic) {
        if (this.registry.containsKey(name)) {
            throw new IllegalArgumentException("Skin provider with name " + name + " is already registered");
        }
        this.registry.put(name, new Entry(provider, isPublic));
    }

    private record Entry(SkinProvider provider, boolean isPublic) {
    }
}

