/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.lionarius.skinrestorer.mixin.ChunkMapAccessor;
import net.lionarius.skinrestorer.mixin.TrackedEntityMixin;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2743;
import net.minecraft.class_2752;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_5250;
import net.minecraft.class_5629;
import net.minecraft.class_7828;
import net.minecraft.class_8042;

public final class PlayerUtils {
    public static final String TEXTURES_KEY = "textures";

    private PlayerUtils() {
    }

    public static class_2561 createPlayerListComponent(Collection<class_3222> players) {
        class_5250 component = class_2561.method_43473();
        int index = 0;
        for (class_3222 player : players) {
            component.method_10852(Objects.requireNonNull(player.method_5476()));
            if (++index >= players.size()) continue;
            component.method_27693(", ");
        }
        return component;
    }

    public static boolean isFakePlayer(class_3222 player) {
        return player.getClass() != class_3222.class;
    }

    public static void refreshPlayer(class_3222 player) {
        class_3218 serverLevel = player.method_51469();
        class_3324 playerList = serverLevel.method_8503().method_3760();
        class_3898 chunkMap = serverLevel.method_14178().field_17254;
        playerList.method_14581((class_2596)new class_8042(List.of(new class_7828(List.of(player.method_5667())), class_2703.method_43886(Collections.singleton(player)))));
        TrackedEntityMixin trackedEntity = (TrackedEntityMixin)((ChunkMapAccessor)chunkMap).getEntityMap().get(player.method_5628());
        if (trackedEntity != null) {
            Set<class_5629> seenBy = Set.copyOf(trackedEntity.getSeenBy());
            for (class_5629 observerConnection : seenBy) {
                class_3222 observer = observerConnection.method_32311();
                trackedEntity.invokeRemovePlayer(observer);
                TrackedEntityMixin trackedObserverEntity = (TrackedEntityMixin)((ChunkMapAccessor)chunkMap).getEntityMap().get(observer.method_5628());
                if (trackedObserverEntity != null) {
                    trackedObserverEntity.invokeRemovePlayer(player);
                    trackedObserverEntity.invokeUpdatePlayer(player);
                }
                trackedEntity.invokeUpdatePlayer(observer);
            }
        }
        if (!player.method_29504()) {
            player.field_13987.method_14364((class_2596)new class_8042(List.of(new class_2724(player.method_52374(serverLevel), 3), new class_2668(class_2668.field_46637, 0.0f))));
            player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            class_1297 vehicle = player.method_5854();
            if (vehicle != null) {
                player.field_13987.method_14364((class_2596)new class_2752(vehicle));
            }
            if (!player.method_5685().isEmpty()) {
                player.field_13987.method_14364((class_2596)new class_2752((class_1297)player));
            }
            player.method_7355();
            player.method_7255(0);
            playerList.method_14576(player);
            playerList.method_14606(player, serverLevel);
            playerList.method_14594(player);
            PlayerUtils.sendActivePlayerEffects(player);
        }
    }

    public static void sendActivePlayerEffects(class_3222 player) {
        for (class_1293 effect : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), effect));
        }
    }

    public static Property getPlayerSkin(GameProfile profile) {
        return profile.getProperties().get((Object)TEXTURES_KEY).stream().findFirst().orElse(null);
    }

    public static void applyRestoredSkin(GameProfile profile, Property skin) {
        profile.getProperties().removeAll((Object)TEXTURES_KEY);
        if (skin != null) {
            profile.getProperties().put((Object)TEXTURES_KEY, (Object)skin);
        }
    }

    public static boolean areSkinPropertiesEquals(Property x, Property y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.equals((Object)y)) {
            return true;
        }
        JsonObject xJson = JsonUtils.skinPropertyToJson(x);
        JsonObject yJson = JsonUtils.skinPropertyToJson(y);
        if (xJson == null || yJson == null) {
            return false;
        }
        return xJson.equals((Object)yJson);
    }

    public static Property findTexturesProperty(JsonArray properties) {
        Property textures = null;
        for (JsonElement property : properties) {
            JsonObject propertyObject = property.getAsJsonObject();
            if (propertyObject == null) continue;
            try {
                textures = JsonUtils.fromJson((JsonElement)propertyObject, Property.class);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (textures == null) {
            throw new IllegalStateException("no textures in profile");
        }
        return textures;
    }
}

