/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.lionarius.skinrestorer.SkinRestorer;

public final class WebUtils {
    public static final String USER_AGENT = String.format("SkinRestorer/%d", System.currentTimeMillis() % 65535L);
    private static final HttpClient HTTP_CLIENT;

    private WebUtils() {
    }

    public static HttpResponse<String> executeRequest(HttpRequest request) throws IOException {
        try {
            HttpRequest modifiedRequest = HttpRequest.newBuilder(request, (name, value) -> true).header("User-Agent", USER_AGENT).build();
            HttpResponse<String> response = HTTP_CLIENT.send(modifiedRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 500) {
                throw new IOException("server error " + response.statusCode());
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static void throwOnClientErrors(HttpResponse<?> response) {
        String message = null;
        switch (response.statusCode()) {
            case 400: {
                message = "bad request";
                break;
            }
            case 401: {
                message = "unauthorized";
                break;
            }
            case 403: {
                message = "forbidden";
                break;
            }
            case 404: {
                message = "not found";
                break;
            }
            case 405: {
                message = "method not allowed";
                break;
            }
            case 408: {
                message = "request timeout";
                break;
            }
            case 429: {
                message = "too many requests";
            }
        }
        if (message != null) {
            throw new IllegalStateException(message);
        }
    }

    static {
        HttpClient.Builder builder = HttpClient.newBuilder();
        String proxy = SkinRestorer.getConfig().getProxy();
        try {
            int colonIndex;
            if (proxy != null && (colonIndex = proxy.lastIndexOf(58)) != -1) {
                String host = proxy.substring(0, colonIndex);
                int port = Integer.parseInt(proxy.substring(colonIndex + 1));
                builder.proxy(ProxySelector.of(InetSocketAddress.createUnresolved(host, port)));
            }
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.error("failed to parse proxy", (Throwable)e);
        }
        try {
            builder.connectTimeout(Duration.of(SkinRestorer.getConfig().getRequestTimeout(), ChronoUnit.SECONDS));
        }
        catch (IllegalArgumentException e) {
            SkinRestorer.LOGGER.error("failed to set request timeout", (Throwable)e);
            builder.connectTimeout(Duration.of(10L, ChronoUnit.SECONDS));
        }
        HTTP_CLIENT = builder.build();
    }
}

