/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.pcal.fastback.commands.CreateFileRemoteCommand;
import net.pcal.fastback.commands.DeleteCommand;
import net.pcal.fastback.commands.FullCommand;
import net.pcal.fastback.commands.GcCommand;
import net.pcal.fastback.commands.HelpCommand;
import net.pcal.fastback.commands.InfoCommand;
import net.pcal.fastback.commands.InitCommand;
import net.pcal.fastback.commands.ListCommand;
import net.pcal.fastback.commands.LocalCommand;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.commands.PruneCommand;
import net.pcal.fastback.commands.PushCommand;
import net.pcal.fastback.commands.RemoteDeleteCommand;
import net.pcal.fastback.commands.RemoteListCommand;
import net.pcal.fastback.commands.RemotePruneCommand;
import net.pcal.fastback.commands.RemoteRestoreCommand;
import net.pcal.fastback.commands.RestoreCommand;
import net.pcal.fastback.commands.SetCommand;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.utils.EnvironmentUtils;
import net.pcal.fastback.utils.Executor;

public class Commands {
    static final int FAILURE = 0;
    static final int SUCCESS = 1;

    public static LiteralArgumentBuilder<class_2168> createBackupCommand(PermissionsFactory<class_2168> pf) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"backup").requires(pf.require("fastback.command"))).executes(HelpCommand::generalHelp);
        InitCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        LocalCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        FullCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        InfoCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        RestoreCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        CreateFileRemoteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        PruneCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        DeleteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        GcCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        ListCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        PushCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        RemoteListCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        RemoteDeleteCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        RemotePruneCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        RemoteRestoreCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        SetCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        HelpCommand.INSTANCE.register((LiteralArgumentBuilder<class_2168>)root, pf);
        return root;
    }

    static Predicate<class_2168> subcommandPermission(String subcommandName, PermissionsFactory<class_2168> pf) {
        String permName = "fastback.command." + subcommandName;
        return pf.require(permName);
    }

    static <V> V getArgumentNicely(String argName, Class<V> clazz, CommandContext<?> cc, UserLogger log) {
        try {
            return (V)cc.getArgument(argName, clazz);
        }
        catch (IllegalArgumentException iae) {
            Commands.missingArgument(argName, log);
            return null;
        }
    }

    static int missingArgument(String argName, CommandContext<class_2168> cc) {
        return Commands.missingArgument(argName, UserLogger.ulog(cc));
    }

    static int missingArgument(String argName, UserLogger log) {
        log.message(UserMessage.styledLocalized("fastback.chat.missing-argument", UserMessage.UserMessageStyle.ERROR, argName));
        return 0;
    }

    static void gitOp(Executor.ExecutionLock lock, UserLogger ulog, GitOp op) {
        try {
            Executor.executor().execute(lock, ulog, () -> {
                Path worldSaveDir = Mod.mod().getWorldDirectory();
                RepoFactory rf = RepoFactory.rf();
                if (!rf.isGitRepo(worldSaveDir)) {
                    if (!EnvironmentUtils.isNativeOk(true, ulog, true)) {
                        return;
                    }
                    ulog.message(UserMessage.styledLocalized("fastback.chat.not-enabled", UserMessage.UserMessageStyle.ERROR, new Object[0]));
                    return;
                }
                try (Repo repo = rf.load(worldSaveDir);){
                    GitConfig repoConfig = repo.getConfig();
                    if (!EnvironmentUtils.isNativeOk(repoConfig, ulog, false)) {
                        return;
                    }
                    if (!repoConfig.getBoolean(FastbackConfigKey.IS_BACKUP_ENABLED)) {
                        ulog.message(UserMessage.styledLocalized("fastback.chat.not-enabled", UserMessage.UserMessageStyle.ERROR, new Object[0]));
                    } else {
                        op.execute(repo);
                    }
                }
                catch (Exception e) {
                    ulog.message(UserMessage.styledLocalized("fastback.chat.internal-error", UserMessage.UserMessageStyle.ERROR, new Object[0]));
                    SystemLogger.syslog().error(e);
                }
                finally {
                    Mod.mod().clearHudText();
                }
            });
        }
        catch (Exception e) {
            ulog.internalError();
            SystemLogger.syslog().error(e);
        }
    }

    static interface GitOp {
        public void execute(Repo var1) throws Exception;
    }
}

