/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.commands.SnapshotNameSuggestions;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.Executor;

enum DeleteCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "delete";
    private static final String ARGUMENT = "snapshot";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, PermissionsFactory<class_2168> pf) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).then(class_2170.method_9244((String)ARGUMENT, (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)SnapshotNameSuggestions.local()).executes(DeleteCommand::delete)));
    }

    private static int delete(CommandContext<class_2168> cc) {
        UserLogger log = UserLogger.ulog(cc);
        Commands.gitOp(Executor.ExecutionLock.WRITE, log, repo -> {
            String snapshotName = Commands.getArgumentNicely(ARGUMENT, String.class, cc.getLastChild(), log);
            SnapshotId sid = repo.createSnapshotId(snapshotName);
            String branchName = sid.getBranchName();
            repo.deleteLocalBranches(List.of(branchName));
            log.message(UserMessage.localized("fastback.chat.delete-done", snapshotName));
        });
        return 1;
    }
}

