/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.utils.Executor;

enum ListCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "list";

    @Override
    public void register(LiteralArgumentBuilder<class_2168> argb, PermissionsFactory<class_2168> pf) {
        argb.then(((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(this::execute));
    }

    private int execute(CommandContext<class_2168> cc) {
        try (UserLogger ulog = UserLogger.ulog(cc);){
            if (!RepoFactory.rf().doInitCheck(Mod.mod().getWorldDirectory(), ulog)) {
                int n = 0;
                return n;
            }
            Commands.gitOp(Executor.ExecutionLock.NONE, ulog, repo -> {
                ArrayList<SnapshotId> snapshots = new ArrayList<SnapshotId>(repo.getLocalSnapshots());
                Collections.sort(snapshots);
                for (SnapshotId sid : snapshots) {
                    ulog.message(UserMessage.raw(sid.getShortName()));
                }
            });
        }
        return 1;
    }
}

