/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.SnapshotId;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SchedulableAction {
    NONE("none"){

        public Callable<Void> getTask(Repo repo, UserLogger ulog) {
            return () -> null;
        }
    }
    ,
    LOCAL("local"){

        public Callable<Void> getTask(Repo repo, UserLogger ulog) {
            return () -> {
                repo.doCommitSnapshot(ulog);
                return null;
            };
        }
    }
    ,
    FULL("full"){

        public Callable<Void> getTask(Repo repo, UserLogger ulog) {
            return () -> {
                repo.doCommitAndPush(ulog);
                return null;
            };
        }
    }
    ,
    FULL_GC("full-gc"){

        public Callable<Void> getTask(Repo repo, UserLogger ulog) {
            return () -> {
                repo.doCommitAndPush(ulog);
                Collection<SnapshotId> pruned = repo.doLocalPrune(ulog);
                if (pruned.size() > 0) {
                    repo.doGc(ulog);
                }
                return null;
            };
        }
    };

    public static final SchedulableAction DEFAULT_SHUTDOWN_ACTION;
    private final String configValue;

    public static SchedulableAction forConfigValue(GitConfig c, FastbackConfigKey key) {
        String configValue = c.getString(key);
        if (configValue == null) {
            return null;
        }
        return SchedulableAction.forConfigValue(configValue);
    }

    public static SchedulableAction forConfigValue(String configValue) {
        if (configValue == null) {
            return null;
        }
        for (SchedulableAction action : SchedulableAction.values()) {
            if (!action.configValue.equals(configValue)) continue;
            return action == NONE ? null : action;
        }
        return null;
    }

    private SchedulableAction(String configValue) {
        this.configValue = Objects.requireNonNull(configValue);
    }

    public String getConfigValue() {
        return this.configValue;
    }

    public String getArgumentName() {
        return this.configValue;
    }

    public abstract Callable<?> getTask(Repo var1, UserLogger var2);

    static {
        DEFAULT_SHUTDOWN_ACTION = FULL;
    }
}

