/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import java.util.function.Supplier;

public interface SystemLogger {
    public static SystemLogger syslog() {
        return Singleton.INSTANCE;
    }

    public void setForceDebugEnabled(boolean var1);

    public void error(String var1);

    public void error(String var1, Throwable var2);

    default public void error(Throwable e) {
        this.error(e.getMessage(), e);
    }

    public void warn(String var1);

    public void info(String var1);

    public void debug(String var1);

    default public void trace(Supplier<String> message) {
        this.debug(message.get());
    }

    public void debug(String var1, Throwable var2);

    default public void debug(Throwable t) {
        this.debug(t.getMessage(), t);
    }

    public static class Singleton {
        private static SystemLogger INSTANCE = null;

        public static void register(SystemLogger logger) {
            INSTANCE = logger;
        }
    }
}

