/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.pcal.fastback.commands.SchedulableAction;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.AutosaveListener;
import net.pcal.fastback.mod.LifecycleListener;
import net.pcal.fastback.mod.MinecraftProvider;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.Repo;
import net.pcal.fastback.repo.RepoFactory;
import net.pcal.fastback.utils.EnvironmentUtils;
import net.pcal.fastback.utils.Executor;
import org.eclipse.jgit.transport.SshSessionFactory;

class ModImpl
implements LifecycleListener,
Mod {
    private final MinecraftProvider fsp;
    private Path tempRestoresDirectory = null;

    ModImpl(MinecraftProvider spi) {
        this.fsp = Objects.requireNonNull(spi);
        spi.setAutoSaveListener(new AutosaveListener());
    }

    @Override
    public Path getDefaultRestoresDir() throws IOException {
        Path restoreDir = this.fsp.getSavesDir();
        if (restoreDir != null) {
            return restoreDir;
        }
        if (this.tempRestoresDirectory == null) {
            this.tempRestoresDirectory = Files.createTempDirectory("fastback-restore", new FileAttribute[0]);
        }
        return this.tempRestoresDirectory;
    }

    @Override
    public void sendChat(UserMessage message, class_2168 scs) {
        this.fsp.sendChat(message, scs);
    }

    @Override
    public void sendBroadcast(UserMessage message) {
        this.fsp.sendBroadcast(message);
    }

    @Override
    public String getModVersion() {
        return this.fsp.getModVersion();
    }

    @Override
    public void setWorldSaveEnabled(boolean enabled) {
        this.fsp.setWorldSaveEnabled(enabled);
    }

    @Override
    public void setMessageScreenText(UserMessage message) {
        this.fsp.setMessageScreenText(message);
    }

    @Override
    public void setHudText(UserMessage message) {
        if (message == null) {
            SystemLogger.syslog().debug("null unexpectedly passed to setHudText, ignoring");
            this.clearHudText();
        } else {
            this.fsp.setHudText(message);
        }
    }

    @Override
    public void clearHudText() {
        this.fsp.clearHudText();
    }

    @Override
    public Path getWorldDirectory() {
        return this.fsp.getWorldDirectory();
    }

    @Override
    public String getWorldName() {
        return this.fsp.getWorldName();
    }

    @Override
    public void addBackupProperties(Map<String, String> props) {
        this.fsp.addBackupProperties(props);
    }

    @Override
    public void saveWorld() {
        this.fsp.saveWorld();
    }

    @Override
    public Collection<Path> getModsBackupPaths() {
        return this.fsp.getModsBackupPaths();
    }

    @Override
    public void onInitialize() {
        String gitVersion = EnvironmentUtils.getGitVersion();
        if (gitVersion == null) {
            SystemLogger.syslog().warn("git is not installed.");
        } else {
            SystemLogger.syslog().info("git is installed: " + gitVersion);
        }
        String gitLfsVersion = EnvironmentUtils.getGitLfsVersion();
        if (gitLfsVersion == null) {
            SystemLogger.syslog().warn("git-lfs is not installed.");
        } else {
            SystemLogger.syslog().info("git-lfs is installed: " + gitLfsVersion);
        }
        if (SshSessionFactory.getInstance() == null) {
            SystemLogger.syslog().warn("An ssh provider was not initialized for jgit.  Operations on a remote repo over ssh will fail.");
        } else {
            SystemLogger.syslog().info("SshSessionFactory: " + SshSessionFactory.getInstance().toString());
        }
        SystemLogger.syslog().debug("onInitialize complete");
    }

    @Override
    public void onWorldStart() {
        Executor.executor().start();
        SystemLogger.syslog().debug("onWorldStart complete");
    }

    @Override
    public void onWorldStop() {
        try (UserLogger ulog = UserLogger.forShutdown();){
            Path worldSaveDir = this.getWorldDirectory();
            if (Executor.executor().getActiveCount() > 0) {
                this.setMessageScreenText(UserMessage.localized("fastback.chat.thread-waiting", new Object[0]));
            }
            Executor.executor().stop();
            this.clearHudText();
            RepoFactory rf = RepoFactory.rf();
            if (rf.isGitRepo(worldSaveDir)) {
                try (Repo repo = rf.load(worldSaveDir);){
                    SchedulableAction action;
                    GitConfig config = repo.getConfig();
                    if (config.getBoolean(FastbackConfigKey.IS_BACKUP_ENABLED) && (action = SchedulableAction.forConfigValue(config, FastbackConfigKey.SHUTDOWN_ACTION)) != null) {
                        this.setMessageScreenText(UserMessage.localized("fastback.message.backing-up", new Object[0]));
                        action.getTask(repo, ulog).call();
                        this.setMessageScreenText(UserMessage.localized("fastback.chat.backup-complete", new Object[0]));
                    }
                }
                catch (Exception e) {
                    SystemLogger.syslog().error("Shutdown action failed.", e);
                }
            }
            SystemLogger.syslog().debug("onWorldStop complete");
        }
    }
}

