/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod.fabric;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2168;
import net.minecraft.class_32;
import net.minecraft.server.MinecraftServer;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.logging.Log4jLogger;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.LifecycleListener;
import net.pcal.fastback.mod.MinecraftProvider;
import net.pcal.fastback.mod.fabric.MixinGateway;
import net.pcal.fastback.mod.fabric.mixins.ServerAccessors;
import net.pcal.fastback.mod.fabric.mixins.SessionAccessors;
import org.apache.logging.log4j.LogManager;

abstract class BaseFabricProvider
implements MinecraftProvider,
MixinGateway {
    static final String MOD_ID = "fastback";
    private MinecraftServer minecraftServer;
    private Runnable autoSaveListener;
    private boolean isWorldSaveEnabled = true;

    protected BaseFabricProvider() {
    }

    @Override
    public void sendBroadcast(UserMessage userMessage) {
        if (this.minecraftServer != null && this.minecraftServer.method_3816()) {
            this.minecraftServer.method_3760().method_43514(MinecraftProvider.messageToText(userMessage), false);
        }
    }

    @Override
    public String getModVersion() {
        Optional optionalModContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (optionalModContainer.isEmpty()) {
            throw new IllegalStateException("Could not find loader for fastback");
        }
        ModMetadata m = ((ModContainer)optionalModContainer.get()).getMetadata();
        return String.valueOf(m.getVersion());
    }

    @Override
    public void setWorldSaveEnabled(boolean enabled) {
        this.isWorldSaveEnabled = enabled;
    }

    @Override
    public void saveWorld() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        this.minecraftServer.method_39218(false, true, true);
    }

    @Override
    public void setAutoSaveListener(Runnable runnable) {
        if (this.autoSaveListener != null) {
            throw new IllegalStateException();
        }
        this.autoSaveListener = Objects.requireNonNull(runnable);
    }

    @Override
    public Path getWorldDirectory() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        class_32.class_5143 session = ((ServerAccessors)this.minecraftServer).getStorageSource();
        return ((SessionAccessors)session).getLevelDirectory().comp_732();
    }

    @Override
    public String getWorldName() {
        if (this.minecraftServer == null) {
            throw new IllegalStateException();
        }
        return this.minecraftServer.method_27728().method_150();
    }

    @Override
    public void addBackupProperties(Map<String, String> props) {
        props.put("fastback-version", this.getModVersion());
        if (this.minecraftServer != null) {
            props.put("minecraft-version", this.minecraftServer.method_3827());
            props.put("minecraft-game-mode", String.valueOf(this.minecraftServer.method_27728().method_210()));
            props.put("minecraft-level-name", this.minecraftServer.method_27728().method_150());
        }
        try {
            Collection mods = FabricLoader.getInstance().getAllMods();
            ArrayList<CallSite> modList = new ArrayList<CallSite>();
            for (ModContainer mc : mods) {
                modList.add((CallSite)((Object)(mc.getMetadata().getId() + ":" + mc.getMetadata().getVersion())));
            }
            Collections.sort(modList);
            StringBuilder modListProp = new StringBuilder();
            for (String string : modList) {
                modListProp.append(string + ", ");
            }
            props.put("fabric-mods", modListProp.toString());
        }
        catch (Exception ohwell) {
            SystemLogger.syslog().error(ohwell);
        }
    }

    @Override
    public Collection<Path> getModsBackupPaths() {
        ArrayList<Path> out = new ArrayList<Path>();
        FabricLoader fl = FabricLoader.getInstance();
        Path gameDir = fl.getGameDir();
        out.add(gameDir.resolve("options.txt\u00b4"));
        out.add(gameDir.resolve("mods"));
        out.add(gameDir.resolve("config"));
        out.add(gameDir.resolve("resourcepacks"));
        return out;
    }

    @Override
    public boolean isWorldSaveEnabled() {
        return this.isWorldSaveEnabled;
    }

    @Override
    public void autoSaveCompleted() {
        if (this.autoSaveListener != null) {
            this.autoSaveListener.run();
        } else {
            SystemLogger.syslog().warn("Autosave just happened but, unexpectedly, no one is listening.");
        }
    }

    void setMinecraftServer(MinecraftServer serverOrNull) {
        if (serverOrNull == null == (this.minecraftServer == null)) {
            throw new IllegalStateException();
        }
        this.minecraftServer = serverOrNull;
    }

    LifecycleListener initialize() {
        SystemLogger.Singleton.register(new Log4jLogger(LogManager.getLogger((String)MOD_ID)));
        LifecycleListener lifecycle = MinecraftProvider.register(this);
        LiteralArgumentBuilder<class_2168> backupCommand = Commands.createBackupCommand(permName -> {
            int requiredLevel = this.isClient() ? 0 : 4;
            return Permissions.require((String)permName, (int)requiredLevel);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, regAccess, env) -> dispatcher.register(backupCommand));
        SystemLogger.syslog().debug("registered backup command");
        MixinGateway.Singleton.register(this);
        lifecycle.onInitialize();
        return lifecycle;
    }
}

