/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import net.pcal.fastback.config.FastbackConfigKey;
import net.pcal.fastback.config.GitConfig;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.BranchUtils;
import net.pcal.fastback.repo.JGitIncrementalProgressMonitor;
import net.pcal.fastback.repo.JGitPercentageProgressMonitor;
import net.pcal.fastback.repo.PushUtils;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.utils.ProcessException;
import net.pcal.fastback.utils.ProcessUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.storage.pack.PackConfig;

abstract class ReclamationUtils {
    ReclamationUtils() {
    }

    static void doReclamation(RepoImpl repo, UserLogger ulog) throws GitAPIException, ProcessException {
        if (repo.getConfig().getBoolean(FastbackConfigKey.IS_NATIVE_GIT_ENABLED)) {
            ReclamationUtils.native_doLfsPrune(repo, ulog);
        } else {
            try {
                ReclamationUtils.jgit_doGc(repo, ulog);
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void native_doLfsPrune(RepoImpl repo, UserLogger ulog) throws ProcessException {
        File worktree = repo.getWorkTree();
        String[] push = new String[]{"git", "-C", worktree.getAbsolutePath(), "-c", "lfs.pruneoffsetdays=999999", "lfs", "prune", "--verbose", "--no-verify-remote"};
        Consumer<String> outputConsumer = line -> ulog.update(UserMessage.styledRaw(line, UserMessage.UserMessageStyle.NATIVE_GIT));
        ProcessUtils.doExec(push, Collections.emptyMap(), outputConsumer, outputConsumer);
        SystemLogger.syslog().debug("native_doLfsPrune");
    }

    private static void jgit_doGc(RepoImpl repo, UserLogger ulog) throws GitAPIException, ParseException, IOException {
        File gitDir = repo.getJGit().getRepository().getDirectory();
        GitConfig config = repo.getConfig();
        ulog.update(UserMessage.styledLocalized("fastback.hud.gc-percent", UserMessage.UserMessageStyle.JGIT, 0));
        SystemLogger.syslog().debug("Stats before gc:");
        SystemLogger.syslog().debug(String.valueOf(repo.getJGit().gc().getStatistics()));
        long sizeBeforeBytes = FileUtils.sizeOfDirectory((File)gitDir);
        SystemLogger.syslog().info("Backup size before gc: " + FileUtils.byteCountToDisplaySize((long)sizeBeforeBytes));
        if (config.getBoolean(FastbackConfigKey.IS_REFLOG_DELETION_ENABLED)) {
            Path reflogsDir = gitDir.toPath().resolve("logs");
            SystemLogger.syslog().debug("Deleting reflogs " + reflogsDir);
            net.pcal.fastback.utils.FileUtils.rmdir(reflogsDir);
        }
        if (config.getBoolean(FastbackConfigKey.IS_BRANCH_CLEANUP_ENABLED)) {
            ArrayList<String> branchesToDelete = new ArrayList<String>();
            for (Ref ref : repo.getJGit().branchList().setListMode(ListBranchCommand.ListMode.ALL).call()) {
                String branchName = BranchUtils.getBranchName(ref);
                if (branchName == null) {
                    SystemLogger.syslog().warn("Non-branch ref returned by branchList: " + ref);
                    continue;
                }
                if (PushUtils.isTempBranch(branchName)) {
                    branchesToDelete.add(branchName);
                    continue;
                }
                if (repo.getSidCodec().isSnapshotBranchName(repo.getWorldId(), branchName)) continue;
                SystemLogger.syslog().warn("Unidentified branch found " + branchName + " - consider removing it with 'git branch -D'");
            }
            if (branchesToDelete.isEmpty()) {
                SystemLogger.syslog().debug("No branches to clean up");
            } else {
                SystemLogger.syslog().debug("Deleting branches: " + branchesToDelete);
                repo.deleteLocalBranches(branchesToDelete);
                SystemLogger.syslog().debug("Branches deleted.");
            }
        }
        GC gc = new GC((FileRepository)repo.getJGit().getRepository());
        gc.setExpireAgeMillis(0L);
        gc.setPackExpireAgeMillis(0L);
        gc.setAuto(false);
        PackConfig pc = new PackConfig();
        pc.setDeltaCompress(false);
        gc.setPackConfig(pc);
        JGitIncrementalProgressMonitor pm = new JGitIncrementalProgressMonitor(new GcProgressMonitor(ulog), 100);
        gc.setProgressMonitor((ProgressMonitor)pm);
        SystemLogger.syslog().debug("Starting garbage collection");
        gc.gc();
        SystemLogger.syslog().debug("Garbage collection complete.");
        SystemLogger.syslog().debug("Stats after gc:");
        SystemLogger.syslog().debug("" + repo.getJGit().gc().getStatistics());
        long sizeAfterBytes = FileUtils.sizeOfDirectory((File)gitDir);
        SystemLogger.syslog().info("Backup size after gc: " + FileUtils.byteCountToDisplaySize((long)sizeAfterBytes));
    }

    private static class GcProgressMonitor
    extends JGitPercentageProgressMonitor {
        private final UserLogger ulog;

        public GcProgressMonitor(UserLogger ulog) {
            this.ulog = Objects.requireNonNull(ulog);
        }

        @Override
        public void progressStart(String task) {
            this.ulog.update(UserMessage.raw(task));
        }

        @Override
        public void progressUpdate(String task, int percentage) {
            String message = task + " " + percentage + "%";
            SystemLogger.syslog().debug(message);
            this.ulog.update(UserMessage.styledLocalized(message, UserMessage.UserMessageStyle.JGIT, new Object[0]));
        }

        @Override
        public void progressDone(String task) {
            UserMessage msg = UserMessage.styledLocalized("fastback.chat.gc-done-no-reclaim", UserMessage.UserMessageStyle.JGIT, new Object[0]);
            SystemLogger.syslog().debug(msg.toString());
            this.ulog.update(msg);
        }

        public void showDuration(boolean enabled) {
        }
    }
}

