/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.repo.BranchUtils;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.repo.WorldId;
import net.pcal.fastback.repo.WorldIdUtils;
import org.eclipse.jgit.lib.Ref;

abstract class SnapshotIdUtils {
    SnapshotIdUtils() {
    }

    static ListMultimap<WorldId, SnapshotId> getSnapshotsPerWorld(Iterable<Ref> refs, SnapshotIdCodec codec) {
        ArrayListMultimap out = ArrayListMultimap.create();
        for (Ref ref : refs) {
            String branchName = BranchUtils.getBranchName(ref);
            if (branchName == null) continue;
            try {
                SnapshotId sid = codec.fromBranch(branchName);
                if (sid == null) continue;
                out.put((Object)sid.getWorldId(), (Object)sid);
            }
            catch (ParseException e) {
                SystemLogger.syslog().warn("Ignoring unexpected branch name " + branchName);
            }
        }
        return out;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum SnapshotIdCodec {
        V2{
            private static final String SEP = "/";

            @Override
            SnapshotId create(WorldId wid) {
                Date date = new Date();
                String shortName = DATE_FORMAT.format(date);
                return new SnapshotIdImpl(wid, date, shortName, 1.getBranchName(wid, shortName));
            }

            @Override
            SnapshotId create(WorldId wid, String shortName) throws ParseException {
                return new SnapshotIdImpl(wid, DATE_FORMAT.parse(shortName), shortName, 1.getBranchName(wid, shortName));
            }

            @Override
            boolean isSnapshotBranchName(WorldId wid, String branchName) {
                return branchName.startsWith(wid + SEP);
            }

            @Override
            SnapshotId fromBranch(String rawBranchName) throws ParseException {
                String[] segments = rawBranchName.split(SEP);
                if (segments.length != 2) {
                    throw new ParseException("Wrong number of segments" + rawBranchName, segments.length);
                }
                WorldIdUtils.WorldIdImpl worldId = new WorldIdUtils.WorldIdImpl(segments[0]);
                Date date = DATE_FORMAT.parse(segments[1]);
                String shortName = DATE_FORMAT.format(date);
                return new SnapshotIdImpl(worldId, date, shortName, rawBranchName);
            }

            private static String getBranchName(WorldId wid, String shortName) {
                return wid + SEP + shortName;
            }
        }
        ,
        V1{
            private static final String PREFIX = "snapshots";
            private static final String SEP = "/";

            @Override
            SnapshotId create(WorldId wid) {
                Date date = new Date();
                String shortName = DATE_FORMAT.format(date);
                return new SnapshotIdImpl(wid, date, shortName, 2.getBranchName(wid, shortName));
            }

            @Override
            SnapshotId create(WorldId wid, String shortName) throws ParseException {
                return new SnapshotIdImpl(wid, DATE_FORMAT.parse(shortName), shortName, 2.getBranchName(wid, shortName));
            }

            @Override
            boolean isSnapshotBranchName(WorldId bid, String branchName) {
                return branchName.startsWith("snapshots/" + bid);
            }

            @Override
            SnapshotId fromBranch(String rawBranchName) throws ParseException {
                if (!rawBranchName.startsWith("snapshots/")) {
                    throw new ParseException("Not a snapshot branch " + rawBranchName, 0);
                }
                String[] segments = rawBranchName.split(SEP);
                if (segments.length < 3) {
                    throw new ParseException("too few segments " + rawBranchName, segments.length);
                }
                WorldIdUtils.WorldIdImpl worldUuid = new WorldIdUtils.WorldIdImpl(segments[1]);
                Date date = DATE_FORMAT.parse(segments[2]);
                String shortName = DATE_FORMAT.format(date);
                return new SnapshotIdImpl(worldUuid, date, shortName, rawBranchName);
            }

            private static String getBranchName(WorldId wid, String shortName) {
                return "snapshots/" + wid + SEP + shortName;
            }
        };

        static final DateFormat DATE_FORMAT;

        abstract SnapshotId create(WorldId var1);

        abstract SnapshotId create(WorldId var1, String var2) throws ParseException;

        abstract SnapshotId fromBranch(String var1) throws ParseException;

        abstract boolean isSnapshotBranchName(WorldId var1, String var2);

        static {
            DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        }
    }

    public record SnapshotIdImpl(WorldId worldUuid, Date date, String shortName, String branchName) implements SnapshotId
    {
        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public Date getDate() {
            return this.date;
        }

        @Override
        public String getBranchName() {
            return this.branchName;
        }

        @Override
        public WorldId getWorldId() {
            return this.worldUuid;
        }

        @Override
        public int compareTo(SnapshotId o) {
            return this.date.compareTo(o.getDate());
        }

        @Override
        public String toString() {
            return this.branchName;
        }
    }
}

