/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;

class FixedCountRetentionPolicy
implements RetentionPolicy {
    private static final int COUNT_DEFAULT = 10;
    private static final String POLICY_NAME = "fixed";
    private static final String L10N_KEY = "fastback.retain.fixed.description";
    private static final String COUNT_PARAM = "count";
    private final int count;

    public static FixedCountRetentionPolicy create(Map<String, String> config) {
        int count = 10;
        if (config != null && config.containsKey(COUNT_PARAM)) {
            try {
                count = Integer.parseInt(config.get(COUNT_PARAM));
            }
            catch (NumberFormatException nfe) {
                SystemLogger.syslog().debug("Ignoring invalided fixed count " + config.get(COUNT_PARAM), nfe);
            }
        }
        return new FixedCountRetentionPolicy(count);
    }

    private FixedCountRetentionPolicy(int count) {
        this.count = count;
    }

    @Override
    public UserMessage getDescription() {
        return UserMessage.localized(L10N_KEY, this.count);
    }

    @Override
    public Collection<SnapshotId> getSnapshotsToPrune(Set<SnapshotId> fromSnapshots) {
        ArrayList<SnapshotId> sorted = new ArrayList<SnapshotId>(fromSnapshots);
        sorted.sort(Collections.reverseOrder());
        if (sorted.size() > this.count) {
            return sorted.subList(this.count - 1, sorted.size() - 1);
        }
        return Collections.emptySet();
    }

    static enum Type implements RetentionPolicyType
    {
        INSTANCE;


        @Override
        public String getName() {
            return FixedCountRetentionPolicy.POLICY_NAME;
        }

        @Override
        public List<RetentionPolicyType.Parameter<?>> getParameters() {
            return List.of(new RetentionPolicyType.Parameter<Integer>(FixedCountRetentionPolicy.COUNT_PARAM, (ArgumentType<Integer>)IntegerArgumentType.integer((int)1), Integer.class));
        }

        @Override
        public RetentionPolicy createPolicy(Map<String, String> config) {
            return FixedCountRetentionPolicy.create(config);
        }

        @Override
        public UserMessage getDescription() {
            return UserMessage.localized(FixedCountRetentionPolicy.L10N_KEY, "<count>");
        }
    }
}

