/*
 * Decompiled with CFR 0.152.
 */
package net.crazedaerialcable.weaponworks.config.objects;

import io.github.hornster.itemfig.api.serialization.config.ConfigObj;
import net.crazedaerialcable.weaponworks.config.helpers.ConfigHelper;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.DiamondGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.GoldenGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.IronGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.NetheriteGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.StoneGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.greatsword.WoodenGreatswordConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.DiamondHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.GoldenHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.IronHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.NetheriteHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.StoneHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.halberd.WoodenHalberdConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.DiamondHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.GoldenHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.IronHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.NetheriteHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.StoneHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.hammer.WoodenHammerConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.DiamondKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.GoldenKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.IronKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.NetheriteKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.StoneKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.katana.WoodenKatanaConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.DiamondMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.GoldenMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.IronMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.NetheriteMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.StoneMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.mace.WoodenMaceConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.DiamondRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.GoldenRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.IronRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.NetheriteRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.StoneRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.rapier.WoodenRapierConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.DiamondScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.GoldenScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.IronScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.NetheriteScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.StoneScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.scythe.WoodenScytheConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.DiamondSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.GoldenSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.IronSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.NetheriteSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.StoneSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.spear.WoodenSpearConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.DiamondWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.GoldenWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.IronWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.NetheriteWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.StoneWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.config.objects.warglaive.WoodenWarglaiveConfigObj;
import net.crazedaerialcable.weaponworks.enums.WeaponTypesEnum;
import net.minecraft.class_1834;

public class ConfigObjectFactory {
    public ConfigObj createObjectConfig(WeaponTypesEnum weaponType, class_1834 tier) throws Exception {
        String weaponId = ConfigHelper.getWeaponId(weaponType, tier);
        switch (weaponType) {
            case GREATSWORD: {
                return this.greatSwordByMaterial(tier, weaponId);
            }
            case HALBERD: {
                return this.halberdByMaterial(tier, weaponId);
            }
            case HAMMER: {
                return this.hammerByMaterial(tier, weaponId);
            }
            case KATANA: {
                return this.katanaByMaterial(tier, weaponId);
            }
            case RAPIER: {
                return this.rapierByMaterial(tier, weaponId);
            }
            case SCYTHE: {
                return this.scytheByMaterial(tier, weaponId);
            }
            case WARGLAIVE: {
                return this.warglaiveByMaterial(tier, weaponId);
            }
            case MACE: {
                return this.maceByMaterial(tier, weaponId);
            }
            case SPEAR: {
                return this.spearByMaterial(tier, weaponId);
            }
        }
        throw new Exception("Unknown weapon type: " + weaponType.name());
    }

    private ConfigObj greatSwordByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenGreatswordConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneGreatswordConfigObj(weaponId);
            }
            case field_8923: {
                return new IronGreatswordConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondGreatswordConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenGreatswordConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteGreatswordConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for greatsword config object adapter config: " + tier.name());
    }

    private ConfigObj halberdByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenHalberdConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneHalberdConfigObj(weaponId);
            }
            case field_8923: {
                return new IronHalberdConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondHalberdConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenHalberdConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteHalberdConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for halberd config object adapter config: " + tier.name());
    }

    private ConfigObj hammerByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenHammerConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneHammerConfigObj(weaponId);
            }
            case field_8923: {
                return new IronHammerConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondHammerConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenHammerConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteHammerConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for hammer config object adapter config: " + tier.name());
    }

    private ConfigObj katanaByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenKatanaConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneKatanaConfigObj(weaponId);
            }
            case field_8923: {
                return new IronKatanaConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondKatanaConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenKatanaConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteKatanaConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for katana config object adapter config: " + tier.name());
    }

    private ConfigObj rapierByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenRapierConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneRapierConfigObj(weaponId);
            }
            case field_8923: {
                return new IronRapierConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondRapierConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenRapierConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteRapierConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for rapier config object adapter config: " + tier.name());
    }

    private ConfigObj scytheByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenScytheConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneScytheConfigObj(weaponId);
            }
            case field_8923: {
                return new IronScytheConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondScytheConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenScytheConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteScytheConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for scythe config object adapter config: " + tier.name());
    }

    private ConfigObj warglaiveByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenWarglaiveConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneWarglaiveConfigObj(weaponId);
            }
            case field_8923: {
                return new IronWarglaiveConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondWarglaiveConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenWarglaiveConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteWarglaiveConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for warglaive config object adapter config: " + tier.name());
    }

    private ConfigObj maceByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenMaceConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneMaceConfigObj(weaponId);
            }
            case field_8923: {
                return new IronMaceConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondMaceConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenMaceConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteMaceConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for mace config object adapter config: " + tier.name());
    }

    private ConfigObj spearByMaterial(class_1834 tier, String weaponId) throws Exception {
        switch (tier) {
            case field_8922: {
                return new WoodenSpearConfigObj(weaponId);
            }
            case field_8927: {
                return new StoneSpearConfigObj(weaponId);
            }
            case field_8923: {
                return new IronSpearConfigObj(weaponId);
            }
            case field_8930: {
                return new DiamondSpearConfigObj(weaponId);
            }
            case field_8929: {
                return new GoldenSpearConfigObj(weaponId);
            }
            case field_22033: {
                return new NetheriteSpearConfigObj(weaponId);
            }
        }
        throw new Exception("Unknown material for spear config object adapter config: " + tier.name());
    }
}

