/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.WeightedRandomBag;
import java.util.HashMap;
import net.minecraft.class_1959;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class SheepHornSettings {
    private static double hasHornsChance = 0.125;
    private static double inheritParentsChance = 0.8;
    private static HashMap<SheepHornColour, Integer> weights = new HashMap();
    private static HashMap<SheepHornColour, Integer> defaultWeights = new HashMap();

    public static double getHornsChance() {
        return hasHornsChance;
    }

    public static void setHornsChance(double chance) {
        hasHornsChance = chance;
    }

    public static double getInheritChance() {
        return inheritParentsChance;
    }

    public static void setInheritChance(double chance) {
        inheritParentsChance = chance;
    }

    public static void setWeight(SheepHornColour colour, int weight) {
        if (weight <= 0) {
            weights.remove((Object)colour);
            return;
        }
        weights.put(colour, weight);
    }

    @Nullable
    public static SheepHornColour getRandomSheepHornColour(class_5819 random, @Nullable class_6880<class_1959> spawnBiome) {
        if (random.method_43058() > hasHornsChance) {
            return null;
        }
        if (spawnBiome == null || !spawnBiome.method_40220(MoreMobVariants.SHEEP_SPAWN_WITH_HORNS)) {
            return null;
        }
        WeightedRandomBag hornColours = new WeightedRandomBag(random);
        weights.forEach(hornColours::addEntry);
        return (SheepHornColour)((Object)hornColours.getRandom());
    }

    public static void resetSettings() {
        hasHornsChance = 0.125;
        inheritParentsChance = 0.8;
        weights.clear();
        weights.put(SheepHornColour.BROWN, defaultWeights.get((Object)SheepHornColour.BROWN));
        weights.put(SheepHornColour.GRAY, defaultWeights.get((Object)SheepHornColour.GRAY));
        weights.put(SheepHornColour.BLACK, defaultWeights.get((Object)SheepHornColour.BLACK));
        weights.put(SheepHornColour.BEIGE, defaultWeights.get((Object)SheepHornColour.BEIGE));
    }

    static {
        defaultWeights.put(SheepHornColour.BROWN, 8);
        defaultWeights.put(SheepHornColour.GRAY, 6);
        defaultWeights.put(SheepHornColour.BLACK, 3);
        defaultWeights.put(SheepHornColour.BEIGE, 1);
    }

    public static enum SheepHornColour {
        BROWN("brown"),
        GRAY("gray"),
        BLACK("black"),
        BEIGE("beige");

        String id;

        private SheepHornColour(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

