/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.playerdata.PlayerDataFactory;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class ClearPlayerDataCommand
implements Command<class_2168> {
    static final int INITIAL_LAST_EXEC_TIME = -1073741824;
    static final int MAX_SECONDS_FOR_CONFIRM = 30;
    static final HashMap<UUID, Integer> LAST_EXEC_TIME_PER_PLAYER_MAP = new HashMap();
    static int lastConsoleExecTime = -1073741824;

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        int lastExecTime;
        class_2168 source = (class_2168)context.getSource();
        if (!EssentialCommands.CONFIG.ENABLE_DELETE_ALL_PLAYER_DATA) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command is not enabled"));
            return -1;
        }
        MinecraftServer server = source.method_9211();
        int currentTicks = server.method_3780();
        if (source.method_43737()) {
            UUID playerId = source.method_9207().method_5667();
            lastExecTime = LAST_EXEC_TIME_PER_PLAYER_MAP.getOrDefault(playerId, -1073741824);
            LAST_EXEC_TIME_PER_PLAYER_MAP.put(playerId, currentTicks);
        } else {
            lastExecTime = lastConsoleExecTime;
            lastConsoleExecTime = currentTicks;
        }
        if (currentTicks - lastExecTime > 600) {
            source.method_9226(() -> class_2561.method_43470((String)"Are you sure you want to disconnect all players and permanently delete ALL Essential Commands player data? This action is irreversible. Run the command again to confirm."), true);
            return 0;
        }
        server.method_3760().method_14597();
        try {
            Path playerDataDirPath = PlayerDataFactory.getPlayerDataDirectoryPath(server);
            File[] files = playerDataDirPath.toFile().listFiles();
            assert (files != null);
            Arrays.stream(files).forEach(File::delete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }
}

