/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.text.ChatConfirmationPrompt;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class HomeSetCommand
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        return HomeSetCommand.exec(context, homeName);
    }

    public int runDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        return HomeSetCommand.exec(context, "unnamed");
    }

    private static int exec(CommandContext<class_2168> context, String homeName) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 senderPlayer = source.method_9207();
        PlayerData playerData = ((ServerPlayerEntityAccess)senderPlayer).ec$getPlayerData();
        if (playerData.existsHome(homeName)) {
            ECText playerEcText = ECText.access(senderPlayer);
            playerData.sendMessage("cmd.home.set.overwrite", new class_2561[]{playerEcText.accent(homeName)});
            new ChatConfirmationPrompt(senderPlayer, "/essentialcommands overwritehome " + homeName, playerEcText.accent("[" + ECText.getInstance().getString("generic.confirm") + "]")).send();
        } else {
            class_5250 homeNameText = ECText.access(senderPlayer).accent(homeName);
            playerData.addHome(homeName, new MinecraftLocation(senderPlayer));
            playerData.save();
            playerData.sendCommandFeedback("cmd.home.set.feedback", new class_2561[]{homeNameText});
        }
        return 0;
    }
}

