/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands.suggestions;

import com.fibermc.essentialcommands.commands.suggestions.ContextFunction;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ListSuggestion {
    private ListSuggestion() {
    }

    public static CompletableFuture<Suggestions> buildSuggestions(SuggestionsBuilder builder, Collection<String> suggestionCollection) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (suggestionCollection.isEmpty()) {
            return Suggestions.empty();
        }
        for (String str : suggestionCollection) {
            if (!str.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    @Contract(pure=true)
    @NotNull
    public static SuggestionProvider<class_2168> of(Supplier<Collection<String>> suggestionCollection) {
        return (context, builder) -> ListSuggestion.buildSuggestions(builder, (Collection)suggestionCollection.get());
    }

    @Contract(pure=true)
    @NotNull
    public static <S> SuggestionProvider<S> ofContext(ContextFunction<CommandContext<S>, Collection<String>> suggestionCollection) {
        return (context, builder) -> ListSuggestion.buildSuggestions(builder, (Collection)suggestionCollection.apply(context));
    }
}

