/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.WorldDataManager;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.commands.MotdCommand;
import com.fibermc.essentialcommands.events.PlayerConnectCallback;
import com.fibermc.essentialcommands.events.PlayerDataManagerTickCallback;
import com.fibermc.essentialcommands.events.PlayerDeathCallback;
import com.fibermc.essentialcommands.events.PlayerLeaveCallback;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.playerdata.ServerTask;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.RespawnCondition;
import dev.jpcode.eccore.config.expression.ExpressionEvaluationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataManager {
    private final ConcurrentHashMap<UUID, PlayerData> dataMap;
    private final List<PlayerData> changedNicknames;
    private final List<String> changedTeams;
    private final List<ServerTask> nextTickTasks;
    private static PlayerDataManager instance;
    public static final Event<PlayerDataManagerTickCallback> TICK_EVENT;

    public PlayerDataManager() {
        instance = this;
        this.changedNicknames = new ArrayList<PlayerData>();
        this.changedTeams = new ArrayList<String>();
        this.nextTickTasks = new ArrayList<ServerTask>();
        this.dataMap = new ConcurrentHashMap();
    }

    public static void init() {
        PlayerConnectCallback.EVENT.register(PlayerDataManager::initializePlayerDataForConnect);
        PlayerLeaveCallback.EVENT.register(PlayerDataManager::handleUnloadPlayerDataForLeave);
        PlayerDeathCallback.EVENT.register(PlayerDataManager::handleSetPreviousLocationForDeath);
        ServerTickEvents.END_SERVER_TICK.register(server -> PlayerDataManager.getInstance().tick(server));
        ServerPlayConnectionEvents.JOIN.register(PlayerDataManager::handleSendMotdForGameJoin);
    }

    private static void handleSendMotdForGameJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        if (EssentialCommands.CONFIG.ENABLE_MOTD) {
            class_3222 player = handler.method_32311();
            MotdCommand.exec(player);
        }
    }

    public static boolean exists() {
        return instance != null;
    }

    public static PlayerDataManager getInstance() {
        return instance != null ? instance : new PlayerDataManager();
    }

    public void markNicknameDirty(PlayerData playerData) {
        this.changedNicknames.add(playerData);
    }

    public void markNicknameDirty(String playerName) {
        this.changedTeams.add(playerName);
    }

    public void queueNicknameUpdatesForAllPlayers() {
        this.scheduleTask("nickname-update", server -> server.method_3760().method_14581((class_2596)new class_2703(EnumSet.of(class_2703.class_5893.field_29139), this.getAllPlayerData().stream().filter(pd -> pd.getNickname().isPresent()).map(PlayerData::getPlayer).toList())));
    }

    public void tick(MinecraftServer server) {
        if (EssentialCommands.CONFIG.NICKNAMES_IN_PLAYER_LIST && server.method_3780() % 100 == 0 && this.changedNicknames.size() + this.changedTeams.size() > 0) {
            class_3324 serverPlayerManager = server.method_3760();
            Set allChangedNicknamePlayers = Stream.concat(this.changedNicknames.stream().map(PlayerData::getPlayer), this.changedTeams.stream().map(arg_0 -> ((class_3324)serverPlayerManager).method_14566(arg_0))).filter(Objects::nonNull).collect(Collectors.toSet());
            server.method_3760().method_14581((class_2596)new class_2703(EnumSet.of(class_2703.class_5893.field_29139), allChangedNicknamePlayers));
            this.changedNicknames.forEach(PlayerData::save);
            this.changedNicknames.clear();
            this.changedTeams.clear();
        }
        if (!this.nextTickTasks.isEmpty()) {
            for (ServerTask nextTickTask : this.nextTickTasks) {
                nextTickTask.task().accept(server);
            }
            this.nextTickTasks.clear();
        }
        ((PlayerDataManagerTickCallback)TICK_EVENT.invoker()).onTick(this, server);
        this.getAllPlayerData().forEach(PlayerData::onTickEnd);
    }

    public void scheduleTask(Runnable task) {
        this.nextTickTasks.add(ServerTask.of(null, task));
    }

    public void scheduleTask(Consumer<MinecraftServer> task) {
        this.nextTickTasks.add(ServerTask.of(null, task));
    }

    public void scheduleTask(@NotNull String id, Consumer<MinecraftServer> task) {
        if (this.nextTickTasks.stream().anyMatch(existingTask -> id.equals(existingTask.id()))) {
            return;
        }
        this.nextTickTasks.add(ServerTask.of(id, task));
    }

    private static void initializePlayerDataForConnect(class_2535 connection, class_3222 player) {
        ServerPlayerEntityAccess playerAccess = (ServerPlayerEntityAccess)player;
        PlayerData playerData = PlayerDataManager.getInstance().loadPlayerData(player);
        playerAccess.ec$setPlayerData(playerData);
        playerAccess.ec$getProfile();
        playerAccess.ec$getEcText();
    }

    private static void handleUnloadPlayerDataForLeave(class_3222 player) {
        PlayerDataManager.getInstance().unloadPlayerData(player);
    }

    public static void handlePlayerDataRespawnSync(class_3222 oldPlayerEntity, class_3222 newPlayerEntity) {
        ServerPlayerEntityAccess oldPlayerAccess = (ServerPlayerEntityAccess)oldPlayerEntity;
        ServerPlayerEntityAccess newPlayerAccess = (ServerPlayerEntityAccess)newPlayerEntity;
        PlayerData playerData = oldPlayerAccess.ec$getPlayerData();
        playerData.updatePlayerEntity(newPlayerEntity);
        newPlayerAccess.ec$setPlayerData(playerData);
        PlayerProfile profile = oldPlayerAccess.ec$getProfile();
        profile.updatePlayerEntity(newPlayerEntity);
        newPlayerAccess.ec$setProfile(profile);
    }

    public static void handleRespawnAtEcSpawn(final class_3222 oldPlayerEntity, final class_3222 newPlayerEntity) {
        WorldDataManager worldMgr = ManagerLocator.getInstance().getWorldDataManager();
        Optional<MinecraftLocation> spawnLocOpt = worldMgr.getSpawn();
        if (spawnLocOpt.isEmpty()) {
            return;
        }
        final MinecraftLocation spawnLoc = spawnLocOpt.get();
        ExpressionEvaluationContext<RespawnCondition> ctx = new ExpressionEvaluationContext<RespawnCondition>(){

            private boolean isSameWorld() {
                return oldPlayerEntity.method_37908().method_27983() == spawnLoc.dim();
            }

            private boolean hasNoBed() {
                class_2338 vanillaPlayerSpawnPoint = newPlayerEntity.method_26280();
                return vanillaPlayerSpawnPoint == null;
            }

            public boolean matches(RespawnCondition condition) {
                return switch (condition) {
                    default -> throw new IncompatibleClassChangeError();
                    case RespawnCondition.Never -> false;
                    case RespawnCondition.Always -> true;
                    case RespawnCondition.SameWorld -> this.isSameWorld();
                    case RespawnCondition.NoBed -> this.hasNoBed();
                };
            }
        };
        if (EssentialCommands.CONFIG.RESPAWN_AT_EC_SPAWN.matches((ExpressionEvaluationContext)ctx)) {
            newPlayerEntity.method_33574(spawnLoc.pos());
            newPlayerEntity.method_51468(newPlayerEntity.method_5682().method_3847(spawnLoc.dim()));
        }
    }

    private static void handleSetPreviousLocationForDeath(class_3222 playerEntity, class_1282 damageSource) {
        PlayerData pData = ((ServerPlayerEntityAccess)playerEntity).ec$getPlayerData();
        if (EssentialCommands.CONFIG.ALLOW_BACK_ON_DEATH) {
            pData.setPreviousLocation(new MinecraftLocation(pData.getPlayer()));
        }
    }

    private PlayerData loadPlayerData(class_3222 player) {
        PlayerData playerData = ((ServerPlayerEntityAccess)player).ec$getPlayerData();
        this.dataMap.put(player.method_5667(), playerData);
        return playerData;
    }

    PlayerData getPlayerDataFromUUID(UUID playerID) {
        return this.dataMap.get(playerID);
    }

    private void unloadPlayerData(class_3222 player) {
        this.dataMap.remove(player.method_5667());
    }

    public Collection<PlayerData> getAllPlayerData() {
        return this.dataMap.values();
    }

    @Nullable
    public PlayerData getByUuid(UUID uuid) {
        return this.dataMap.get(uuid);
    }

    public List<PlayerData> getPlayerDataMatchingNickname(String nickname) {
        return this.dataMap.values().stream().filter(playerData -> playerData.getNickname().map(nick -> nick.getString().equalsIgnoreCase(nickname)).orElse(false)).collect(Collectors.toList());
    }

    static {
        TICK_EVENT = EventFactory.createArrayBacked(PlayerDataManagerTickCallback.class, listeners -> (playerDataManager, server) -> {
            for (PlayerDataManagerTickCallback event : listeners) {
                event.onTick(playerDataManager, server);
                server.method_30002().method_8448();
            }
        });
    }
}

