/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.IServerPlayerEntityData;
import com.fibermc.essentialcommands.types.IStyleProvider;
import com.fibermc.essentialcommands.types.ProfileOption;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jpcode.eccore.config.ConfigUtil;
import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfile
extends class_18
implements IServerPlayerEntityData,
IStyleProvider {
    private class_3222 player;
    private final File saveFile;
    private ProfileOptions profileOptions;
    public static final Map<String, ProfileOption<?>> OPTIONS = Map.ofEntries(new AbstractMap.SimpleEntry<String, ProfileOption<Boolean>>("printTeleportCoordinates", new ProfileOption<Boolean>((ArgumentType<Boolean>)BoolArgumentType.bool(), false, (context, name, profile) -> {
        profile.profileOptions.printTeleportCoordinates = BoolArgumentType.getBool((CommandContext)context, (String)name);
    }, profile -> profile.profileOptions.printTeleportCoordinates)), new AbstractMap.SimpleEntry<String, ProfileOption<String>>("formattingDeault", new ProfileOption<String>((ArgumentType<String>)StringArgumentType.greedyString(), (String)null, (context, name, profile) -> {
        profile.profileOptions.formattingDefault = ConfigUtil.parseStyle((String)StringArgumentType.getString((CommandContext)context, (String)name));
    }, profile -> ConfigUtil.serializeStyle((class_2583)profile.profileOptions.formattingDefault))), new AbstractMap.SimpleEntry<String, ProfileOption<String>>("formattingAccent", new ProfileOption<String>((ArgumentType<String>)StringArgumentType.greedyString(), (String)null, (context, name, profile) -> {
        profile.profileOptions.formattingAccent = ConfigUtil.parseStyle((String)StringArgumentType.getString((CommandContext)context, (String)name));
    }, profile -> ConfigUtil.serializeStyle((class_2583)profile.profileOptions.formattingAccent))));

    public PlayerProfile(@NotNull class_3222 player, File saveFile) {
        this.player = player;
        this.saveFile = saveFile;
        this.profileOptions = new ProfileOptions();
    }

    public boolean shouldPrintTeleportCoordinates() {
        return this.profileOptions.printTeleportCoordinates;
    }

    @Override
    @Nullable
    public class_2583 getFormattingDefault() {
        return this.profileOptions.formattingDefault;
    }

    @Override
    @Nullable
    public class_2583 getFormattingAccent() {
        return this.profileOptions.formattingAccent;
    }

    @Override
    @Nullable
    public class_2583 getFormattingError() {
        return this.profileOptions.formattingError;
    }

    public void fromNbt(class_2487 tag) {
        class_2487 dataTag = tag.method_10562("data");
        this.profileOptions = new ProfileOptions();
        this.profileOptions.formattingDefault = Optional.ofNullable(dataTag.method_10580("formattingDeault")).map(class_2520::method_10714).map(ConfigUtil::parseStyle).orElse(null);
        this.profileOptions.formattingAccent = Optional.ofNullable(dataTag.method_10580("formattingAccent")).map(class_2520::method_10714).map(ConfigUtil::parseStyle).orElse(null);
        this.profileOptions.formattingError = Optional.ofNullable(dataTag.method_10580("formattingError")).map(class_2520::method_10714).map(ConfigUtil::parseStyle).orElse(null);
        this.profileOptions.printTeleportCoordinates = dataTag.method_10577("printTeleportCoordinates");
    }

    public class_2487 method_75(class_2487 tag) {
        if (this.profileOptions.formattingDefault != null) {
            tag.method_10582("formattingDeault", ConfigUtil.serializeStyle((class_2583)this.profileOptions.formattingDefault));
        }
        if (this.profileOptions.formattingAccent != null) {
            tag.method_10582("formattingAccent", ConfigUtil.serializeStyle((class_2583)this.profileOptions.formattingAccent));
        }
        if (this.profileOptions.formattingError != null) {
            tag.method_10582("formattingError", ConfigUtil.serializeStyle((class_2583)this.profileOptions.formattingError));
        }
        tag.method_10556("printTeleportCoordinates", this.profileOptions.printTeleportCoordinates);
        return tag;
    }

    public void save() {
        super.method_17919(this.saveFile);
    }

    @Override
    public class_3222 getPlayer() {
        return this.player;
    }

    @Override
    public void updatePlayerEntity(class_3222 newPlayerEntity) {
        this.player = newPlayerEntity;
    }

    public static PlayerProfile access(@NotNull class_3222 player) {
        return ((ServerPlayerEntityAccess)player).ec$getProfile();
    }

    public static PlayerProfile accessFromContextOrThrow(CommandContext<class_2168> context) throws CommandSyntaxException {
        return PlayerProfile.access(((class_2168)context.getSource()).method_9207());
    }

    private static final class ProfileOptions {
        private class_2583 formattingDefault;
        private class_2583 formattingAccent;
        private class_2583 formattingError;
        private boolean printTeleportCoordinates = true;

        private ProfileOptions() {
        }
    }

    private static final class StorageKey {
        static final String FORMATTING_DEAULT = "formattingDeault";
        static final String FORMATTING_ACCENT = "formattingAccent";
        static final String FORMATTING_ERROR = "formattingError";
        static final String PRINT_TELEPORT_COORDINATES = "printTeleportCoordinates";

        private StorageKey() {
        }
    }
}

