/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.config.PluginConfig;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    private static final WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final HierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new HierarchyLookup(class_2586.class);
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders = new HierarchyLookup(class_1297.class);
    public final PriorityStore<class_2960, IJadeProvider> priorities = new PriorityStore<class_2960, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
    public final HierarchyLookup<IServerExtensionProvider<Object, class_1799>> itemStorageProviders;
    public final HierarchyLookup<IServerExtensionProvider<Object, class_2487>> fluidStorageProviders;
    public final HierarchyLookup<IServerExtensionProvider<Object, class_2487>> energyStorageProviders;
    public final HierarchyLookup<IServerExtensionProvider<Object, class_2487>> progressProviders;

    WailaCommonRegistration() {
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(PluginConfig::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(PluginConfig::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(PluginConfig.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        this.priorities.setConfigFile("jade/sort-order");
        this.itemStorageProviders = new HierarchyLookup(Object.class, true);
        this.fluidStorageProviders = new HierarchyLookup(Object.class, true);
        this.energyStorageProviders = new HierarchyLookup(Object.class, true);
        this.progressProviders = new HierarchyLookup(Object.class, true);
    }

    public static WailaCommonRegistration instance() {
        return INSTANCE;
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<? extends class_2586> block) {
        this.blockDataProviders.register(block, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends class_1297> entity) {
        this.entityDataProviders.register(entity, dataProvider);
    }

    public List<IServerDataProvider<BlockAccessor>> getBlockNBTProviders(class_2586 block) {
        return this.blockDataProviders.get(block);
    }

    public List<IServerDataProvider<EntityAccessor>> getEntityNBTProviders(class_1297 entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<T, class_1799> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<T, class_2487> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<T, class_2487> provider, Class<? extends T> clazz) {
        this.energyStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<T, class_2487> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

