/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.arch.screen.widget.IWidgetLogic;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends class_4280<E>
implements IWidgetLogic {
    protected List<E> emotes = new ArrayList();
    private final class_437 screen;

    public AbstractEmoteEntry<E> getSelectedEntry() {
        return (AbstractEmoteEntry)this.method_25334();
    }

    public AbstractEmoteListWidget(class_310 minecraftClient, int i, int j, int k, int l, class_437 screen) {
        super(minecraftClient, i, j, k, l);
        this.field_22744 = false;
        this.screen = screen;
    }

    public int method_25322() {
        return this.field_22758 - 5;
    }

    protected abstract E newEmoteEntry(class_310 var1, EmoteHolder var2);

    public void emotesSetLeftPos(int left) {
        this.method_48229(left, this.method_46427());
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    public void filter(Supplier<String> string) {
        this.method_25339();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.method_25321((class_350.class_351)emote);
        }
        this.method_25307(0.0);
    }

    public void renderThis(class_332 matrices, int mouseX, int mouseY, float tickDelta) {
        this.method_25394(matrices, mouseX, mouseY, tickDelta);
    }

    protected int method_25329() {
        return this.method_46426() + this.field_22758 - 6;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, class_3675.class_306> pair : ((ClientConfig)EmoteInstance.config).emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.getLeft())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.getLeft()));
        }
        return empties;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends class_4280.class_4281<T> {
        protected final class_310 client;
        public final EmoteHolder emote;

        public AbstractEmoteEntry(class_310 client, EmoteHolder emote) {
            this.client = client;
            this.emote = emote;
        }

        public void method_25343(@NotNull class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrices.method_25294(x - 1, y - 1, x + entryWidth - 9, y + entryHeight + 1, MathHelper.colorHelper((int)66, (int)66, (int)66, (int)128));
            }
            matrices.method_27535(class_310.method_1551().field_1772, this.getEmote().name, (int)((float)(x + 38)), (int)((float)(y + 1)), 0xFFFFFF);
            matrices.method_27535(class_310.method_1551().field_1772, this.getEmote().description, (int)((float)(x + 38)), (int)((float)(y + 12)), 0x808080);
            if (!this.getEmote().author.getString().isEmpty()) {
                class_5250 text = class_2561.method_43471((String)"emotecraft.emote.author").method_27692(class_124.field_1065).method_10852(this.getEmote().author);
                matrices.method_27535(class_310.method_1551().field_1772, (class_2561)text, (int)((float)(x + 38)), (int)((float)(y + 23)), 0x808080);
            }
            if (this.getEmote().getIconIdentifier() != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                class_2960 texture = this.getEmote().getIconIdentifier();
                matrices.method_25293(texture, x, y, 32, 32, 0.0f, 0.0f, 256, 256, 256, 256);
                RenderSystem.disableBlend();
            }
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        @NotNull
        public class_2561 method_37006() {
            return this.emote.name;
        }

        protected abstract void onPressed();
    }
}

