/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.impl;

import com.illusivesoulworks.polymorph.api.common.base.IPolymorphCommon;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphPacketDistributor;
import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IStackRecipeData;
import com.illusivesoulworks.polymorph.common.capability.PolymorphCapabilities;
import com.illusivesoulworks.polymorph.common.util.BlockEntityTicker;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.server.MinecraftServer;

public class PolymorphCommon
implements IPolymorphCommon {
    private static final IPolymorphCommon INSTANCE = new PolymorphCommon();
    private final List<IPolymorphCommon.IBlockEntity2RecipeData> blockEntity2RecipeData = new LinkedList<IPolymorphCommon.IBlockEntity2RecipeData>();
    private final List<IPolymorphCommon.IContainer2BlockEntity> container2BlockEntities = new LinkedList<IPolymorphCommon.IContainer2BlockEntity>();
    private final List<IPolymorphCommon.IContainer2ItemStack> container2ItemStacks = new LinkedList<IPolymorphCommon.IContainer2ItemStack>();
    private final List<IPolymorphCommon.IItemStack2RecipeData> itemStack2RecipeData = new LinkedList<IPolymorphCommon.IItemStack2RecipeData>();
    private final IPolymorphPacketDistributor distributor = Services.PLATFORM.getPacketDistributor();
    private MinecraftServer server = null;

    public static IPolymorphCommon get() {
        return INSTANCE;
    }

    @Override
    public IPolymorphPacketDistributor getPacketDistributor() {
        return this.distributor;
    }

    @Override
    public void setServer(MinecraftServer server) {
        this.server = server;
        BlockEntityTicker.clear();
    }

    @Override
    public Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public Optional<? extends IBlockEntityRecipeData> tryCreateRecipeData(class_2586 blockEntity) {
        for (IPolymorphCommon.IBlockEntity2RecipeData function : this.blockEntity2RecipeData) {
            IBlockEntityRecipeData recipeData = function.createRecipeData(blockEntity);
            if (recipeData == null) continue;
            return Optional.of(recipeData);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends IBlockEntityRecipeData> getRecipeData(class_2586 blockEntity) {
        return PolymorphCapabilities.getRecipeData(blockEntity);
    }

    @Override
    public Optional<? extends IBlockEntityRecipeData> getRecipeDataFromBlockEntity(class_1703 container) {
        for (IPolymorphCommon.IContainer2BlockEntity function : this.container2BlockEntities) {
            class_2586 blockEntity = function.getBlockEntity(container);
            if (blockEntity == null) continue;
            return this.getRecipeData(blockEntity);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends IStackRecipeData> tryCreateRecipeData(class_1799 stack) {
        for (IPolymorphCommon.IItemStack2RecipeData function : this.itemStack2RecipeData) {
            IStackRecipeData recipeData = function.createRecipeData(stack);
            if (recipeData == null) continue;
            return Optional.of(recipeData);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends IStackRecipeData> getRecipeData(class_1799 stack) {
        return PolymorphCapabilities.getRecipeData(stack);
    }

    @Override
    public Optional<? extends IStackRecipeData> getRecipeDataFromItemStack(class_1703 pContainer) {
        for (IPolymorphCommon.IContainer2ItemStack function : this.container2ItemStacks) {
            class_1799 itemstack = function.getItemStack(pContainer);
            if (itemstack.method_7960()) continue;
            return this.getRecipeData(itemstack);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends IPlayerRecipeData> getRecipeData(class_1657 player) {
        return PolymorphCapabilities.getRecipeData(player);
    }

    @Override
    public void registerBlockEntity2RecipeData(IPolymorphCommon.IBlockEntity2RecipeData blockEntity2RecipeData) {
        this.blockEntity2RecipeData.add(blockEntity2RecipeData);
    }

    @Override
    public void registerContainer2BlockEntity(IPolymorphCommon.IContainer2BlockEntity container2BlockEntity) {
        this.container2BlockEntities.add(container2BlockEntity);
    }

    @Override
    public void registerItemStack2RecipeData(IPolymorphCommon.IItemStack2RecipeData stack2RecipeData) {
        this.itemStack2RecipeData.add(stack2RecipeData);
    }

    @Override
    public void registerContainer2ItemStack(IPolymorphCommon.IContainer2ItemStack container2ItemStack) {
        this.container2ItemStacks.add(container2ItemStack);
    }
}

