/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.config;

import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.MatchesRegex;
import io.github.jamalam360.jamlib.config.RequiresRestart;
import io.github.jamalam360.jamlib.config.WithinRange;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public interface ConfigExtensions<T> {
    default public List<Link> getLinks() {
        return List.of();
    }

    default public List<ValidationError> getValidationErrors(ConfigManager<T> manager, FieldValidationInfo info) {
        Annotation annotation;
        ArrayList<ValidationError> result = new ArrayList<ValidationError>();
        if (info.backingField().isAnnotationPresent(MatchesRegex.class)) {
            annotation = info.backingField().getAnnotation(MatchesRegex.class);
            if (!info.value().toString().matches(annotation.value())) {
                result.add(new ValidationError(ValidationError.Type.ERROR, info, (class_2561)class_2561.method_43469((String)"config.jamlib.matches_regex_tooltip", (Object[])new Object[]{annotation.value()})));
            }
        }
        if (info.backingField().isAnnotationPresent(RequiresRestart.class) && !info.initialValue().equals(info.value())) {
            result.add(new ValidationError(ValidationError.Type.WARNING, info, (class_2561)class_2561.method_43471((String)"config.jamlib.requires_restart_tooltip")));
        }
        if (info.backingField().isAnnotationPresent(WithinRange.class)) {
            if (info.backingField().getType() != Double.TYPE && info.backingField().getType() != Double.class && info.backingField().getType() != Float.TYPE && info.backingField().getType() != Float.class && info.backingField().getType() != Integer.TYPE && info.backingField().getType() != Integer.class && info.backingField().getType() != Long.TYPE && info.backingField().getType() != Long.class) {
                JamLib.LOGGER.error("Field " + info.backingField().getName() + " is annotated with @WithinRange but is not a number!");
            } else {
                annotation = info.backingField().getAnnotation(WithinRange.class);
                Number value = (Number)info.value();
                if (value.doubleValue() < annotation.min() || value.doubleValue() > annotation.max()) {
                    result.add(new ValidationError(ValidationError.Type.ERROR, info, (class_2561)class_2561.method_43469((String)"config.jamlib.within_range_tooltip", (Object[])new Object[]{annotation.min(), annotation.max()})));
                }
            }
        }
        return result;
    }

    public record FieldValidationInfo(String name, Object value, Object initialValue, Field backingField) {
    }

    public record ValidationError(Type type, FieldValidationInfo field, class_2561 message) {

        public static enum Type {
            WARNING,
            ERROR;

            private final class_2960 texture = JamLib.id("textures/gui/validation_" + this.name().toLowerCase() + ".png");

            public class_2960 getTexture() {
                return this.texture;
            }
        }
    }

    public static class Link {
        public static final class_2960 DISCORD = JamLib.id("textures/gui/link_discord.png");
        public static final class_2960 GENERIC_LINK = JamLib.id("textures/gui/link_generic.png");
        public static final class_2960 GITHUB = JamLib.id("textures/gui/link_github.png");
        private final class_2960 texture;
        private final URL url;
        private final class_2561 tooltip;

        public Link(class_2960 texture, String url, class_2561 tooltip) {
            this.texture = texture;
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                JamLib.LOGGER.error("Malformed URL for config screen link: " + url);
                throw new RuntimeException(e);
            }
            this.tooltip = tooltip;
        }

        public Link(class_2960 texture, URL url, class_2561 tooltip) {
            this.texture = texture;
            this.url = url;
            this.tooltip = tooltip;
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public URL getUrl() {
            return this.url;
        }

        public class_2561 getTooltip() {
            return this.tooltip;
        }
    }
}

