/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.items.trinkets;

import com.glisco.things.Things;
import com.glisco.things.client.ThingsClient;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.items.TrinketItemWithOptionalTooltip;
import com.glisco.things.misc.SockDataComponent;
import dev.emi.trinkets.api.SlotReference;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.endec.KeyedEndec;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SocksItem
extends TrinketItemWithOptionalTooltip {
    public static final KeyedEndec<Boolean> JUMPY_KEY = Endec.BOOLEAN.keyed("Jumpy", (Object)false);
    public static final KeyedEndec<Boolean> JUMP_BOOST_TOGGLE_KEY = Endec.BOOLEAN.keyed("JumpBoostDisabled", (Object)false);
    public static final KeyedEndec<Integer> SPEED_KEY = Endec.INT.keyed("Speed", (Object)0);

    public SocksItem() {
        super((class_1792.class_1793)new OwoItemSettings().maxCount(1).group(Things.THINGS_GROUP));
    }

    public static class_1799 create(int speed, boolean jumpy) {
        class_1799 stack = new class_1799((class_1935)ThingsItems.SOCKS);
        stack.put(SPEED_KEY, (Object)speed);
        stack.put(JUMPY_KEY, (Object)jumpy);
        return stack;
    }

    public void tick(class_1799 stack, SlotReference slotRef, class_1309 entity) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        SockDataComponent sockData = (SockDataComponent)Things.SOCK_DATA.get((Object)player);
        class_2487 nbt = stack.method_7948();
        sockData.jumpySocksEquipped = (Boolean)nbt.get(JUMPY_KEY);
        if (player.method_37908().field_9236) {
            return;
        }
        sockData.updateSockSpeed(slotRef.index(), (Integer)nbt.get(SPEED_KEY) + 1);
        if (!sockData.jumpySocksEquipped || ((Boolean)nbt.get(JUMP_BOOST_TOGGLE_KEY)).booleanValue()) {
            return;
        }
        player.method_6092(new class_1293(class_1294.field_5913, 5, 1, true, false, true));
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        ((SockDataComponent)Things.SOCK_DATA.get((Object)entity)).jumpySocksEquipped = false;
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        int speed = (Integer)stack.get(SPEED_KEY);
        ((SockDataComponent)Things.SOCK_DATA.get((Object)player)).modifySpeed(-Things.CONFIG.sockPerLevelSpeedAmplifier() * (float)(speed + 1));
        ((SockDataComponent)Things.SOCK_DATA.get((Object)player)).clearSockSpeed(slot.index());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void append(List<class_2561> tooltip) {
        this.appendWrapped(tooltip, (class_2561)class_2561.method_43469((String)this.tooltipTranslationKey(), (Object[])new Object[]{KeyBindingHelper.getBoundKeyOf((class_304)ThingsClient.TOGGLE_SOCKS_JUMP_BOOST).method_27445()}));
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int speed;
        if (((Boolean)stack.get(JUMPY_KEY)).booleanValue()) {
            tooltip.add((class_2561)TextOps.withColor((String)"\u2191 ", (int)((Boolean)stack.get(JUMP_BOOST_TOGGLE_KEY) != false ? TextOps.color((class_124)class_124.field_1080) : 3462300)).method_10852((class_2561)TextOps.translateWithColor((String)"item.things.socks.jumpy", (int)TextOps.color((class_124)class_124.field_1080))));
        }
        if ((speed = ((Integer)stack.get(SPEED_KEY)).intValue()) < 3) {
            tooltip.add((class_2561)TextOps.withColor((String)"\u2604 ", (int)3453396).method_10852((class_2561)TextOps.translateWithColor((String)("item.things.socks.speed_" + speed), (int)TextOps.color((class_124)class_124.field_1080))));
        } else {
            tooltip.add((class_2561)TextOps.withColor((String)"\u2604 ", (int)3453396).method_10852((class_2561)TextOps.translateWithColor((String)"item.things.socks.speed_illegal", (int)TextOps.color((class_124)class_124.field_1061))).method_10852((class_2561)TextOps.withColor((String)(" (" + speed + ")"), (int)TextOps.color((class_124)class_124.field_1061))));
        }
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        super.method_7851(stack, world, tooltip, context);
    }
}

